async function carregaDuplicatas(codcli, tela, callbackPosicaoQuatroDoParametro) {
  let bCliente = null;
  let bAtraso = null;
  const paramsPedido = await BuscaParametrosPedido();
  const parametrosVenda = await BuscaParametrosVenda();
  const todasEmpresas = $('#checkTodasEmpresas').prop('checked') ? 'S' : 'N'

  if (tela === 'PEDIDO') {
    bAtraso = paramsPedido[16].VALOR;
  } else if (tela === 'VENDA') {
    bCliente = parametrosVenda[3];
    bAtraso = parametrosVenda[23];
  };

  let bDuplCheq;
  try {
    bDuplCheq = await consultaDupAberto(codcli, todasEmpresas, bAtraso === '4');
  } catch (error) {
    console.error(error);
  };

  if (bAtraso == '4') {
    if (($("#tabela-duplicatas").DataTable().rows().count() > 0) && bDuplCheq) {
      callbackPosicaoQuatroDoParametro();
    }
  } else if ((tela === 'PEDIDO' && bAtraso != "3") || (pegaChave(bCliente) != codcli && bAtraso != "3")) {
    if (($("#tabela-duplicatas").DataTable().rows().count() > 0) && bDuplCheq) {
      return new Promise((resolve, reject) => {
        $("#modal-receberabertos").modal("show");

        $('#modal-receberabertos').on('hide.bs.modal', () => {
          resolve()
        })
      })
    }
  }
};

async function buscaDuplicatasEmAberto(codcli, todasEmpresas, apenasDoMesVigente = false) {
  try {
    const url = "/sisplan/receber/v1/receberabertos?";
    const response = await requisicao(
      "GET",
      url,
      `CLIENTE=${codcli}&DUPLICATA=S&ANTECIPACAO=S&CHEQUE=S&CHEQUEDEV=S&TODASEMPRESAS=${todasEmpresas}&MES_VIGENTE=${apenasDoMesVigente ? 'S' : 'N'}`,
      null
    );

    if (!response) {
      return;
    }
    if (response.status != 200) {
      msgErro(response.mensagem);
      return;
    }

    const jsonStr = await response.json();

    return jsonStr;
  } catch (error) {
    console.error(error);
  }
}

async function consultaDupAberto(codcli, todasEmpresas, apenasDoMesVigente = false) {
  let data = new Date();
  let vAVencer = 0;
  let vVencido = 0;
  let vAnteci = 0;
  let vCheqD = 0;
  let vAberto = 0;
  let bDuplCheq = false;

  data = `${data.getUTCFullYear()}-${String(
    data.getUTCMonth() + 1
  ).padStart(2, 0)}-${String(data.getUTCDate()).padStart(2, 0)}`;

  const jsonStr = await buscaDuplicatasEmAberto(codcli, todasEmpresas, apenasDoMesVigente);
  $("#tabela-duplicatas").DataTable().rows().remove().draw(false);
  if (!jsonStr || jsonStr.length == 0) {
    return;
  }

  $("#tabela-duplicatas").DataTable({
    paging: false,
    filter: false,
    info: false,
    order: false,
    destroy: true,
    scrollY: "300px",
    autowidth: true,
  });

  for (let i = 0; i < jsonStr.length; i++) {
    $("#tabela-duplicatas")
      .DataTable()
      .row.add([
        jsonStr[i].NUMERO,
        `${jsonStr[i].DT_EMISSAO.split("-")[2]}/${jsonStr[i].DT_EMISSAO.split("-")[1]
        }/${jsonStr[i].DT_EMISSAO.split("-")[0]}`,
        `${jsonStr[i].DT_VENCTO.split("-")[2]}/${jsonStr[i].DT_VENCTO.split("-")[1]
        }/${jsonStr[i].DT_VENCTO.split("-")[0]}`,
        jsonStr[i].SALDO,
        jsonStr[i].EMP.replace("_", ""),
      ]);
      // .draw(false); // draw dentro do for trava..
    if ((jsonStr[i].DT_VENCTO <= data) && (['DUPL', 'CHEQ'].includes(jsonStr[i].STATUS))) {
      vVencido = parseFloat(vVencido) + parseFloat(jsonStr[i].SALDO);
      bDuplCheq = true;
    } else if ((jsonStr[i].DT_VENCTO > data) && (['DUPL', 'CHEQ'].includes(jsonStr[i].STATUS))) {
      vAVencer = parseFloat(vAVencer) + parseFloat(jsonStr[i].SALDO);
      bDuplCheq = true;
    } else if (['ANTE'].includes(jsonStr[i].STATUS)) {
      vAnteci = parseFloat(vAnteci) + parseFloat(jsonStr[i].SALDO);
    } else if (['CHDE'].includes(jsonStr[i].STATUS)) {
      vCheqD = parseFloat(vCheqD) + parseFloat(jsonStr[i].SALDO);
      bDuplCheq = true;
    }
  }
  $("#tabela-duplicatas").DataTable().draw(false);
  vAberto = parseFloat(vVencido) + parseFloat(vAVencer) + parseFloat(vCheqD) - parseFloat(vAnteci);
  $("#txtValDupVencer").html(vAVencer.toFixed(2));
  $("#txtValDupVencida").html(vVencido.toFixed(2));
  $("#txtValAntec").html(vAnteci.toFixed(2));
  $("#txtValChequeDevol").html(vCheqD.toFixed(2));
  $("#txtValTotAberto").html(vAberto.toFixed(2));
  $("#txtValDupVencida").css("color", "red");
  $("#txtValAntec").css("color", "green");
  $("#txtValChequeDevol").css("color", "purple");

  setTimeout(() => {
    $("#tabela-duplicatas").DataTable().columns.adjust().draw(false);
  }, 200);
  return bDuplCheq;
};

$(document).ready(async function () {
  $('#btn-confirmarduplicata').on('click', function () {
    $('#modal-receberabertos').modal('hide');
  });

  $('#checkTodasEmpresas').on('click', async function () {
    let sCodCli = pegaChave('#txtCliente');
    await consultaDupAberto(sCodCli, $(this).prop('checked') ? 'S' : 'N');
  });
})