$("#tutorial").on("click", function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: "Sair",
            closeBtnText: "Fechar",
            nextBtnText: "Próximo",
            prevBtnText: "Anterior",
            allowClose: false,
            animate: true,
        });

        driver.defineSteps([
            {
                element: "#formcard1",
                popover: {
                    title: "Dados Gerais",
                    description: "Aqui estão os campos disponíveis para o cadastro, todos os campos obrigatórios terão * ao lado do nome.",
                    position: "top",
                },
            },
            {
                element: "#tutorialSituacao",
                popover: {
                    title: "Situação",
                    description:
                        "Neste campo, podemos selecionar a situação do histórico.",
                    position: "top",
                },
            },
            {
                element: "#tutorialOpcoes",
                popover: {
                    title: "Opções",
                    description:
                        "Aqui podemos selecionar se o registro utiliza Crédito Grupo.",
                    position: "top",
                },
            },
            {
                element: "#tutorialHistorico",
                popover: {
                    title: "Código do Histórico",
                    description:
                        "Esse campo é preenchido automáricamente.",
                    position: "top",
                },
            },
            {
                element: "#tutorialTipo",
                popover: {
                    title: "Tipo de Histórico",
                    description:
                        "Aqui selecionamos o Tipo do histórico.",
                    position: "top",
                },
            },
            {
                element: "#txtDescricao",
                popover: {
                    title: "Descrição do histórico",
                    description:
                        "Podemos adicionar a descrição desse histórico neste campo.",
                    position: "top",
                },
            },
            {
                element: "#txtObservacao",
                popover: {
                    title: "Observações",
                    description:
                        "Aqui, podemos colocar algumas observações sobre este registro.",
                    position: "top",
                },
            },
            {
                element: "#btnVoltar",
                popover: {
                    title: "Voltar",
                    description:
                        "Ao clicar aqui, voltamos a página anterior.",
                    position: "top",
                },
            },
            {
                element: "#gravar",
                popover: {
                    title: "Botão Gravar",
                    description: "Clique aqui para gravar um Histórico.",
                    position: "left",
                },
            },
        ]);
        driver.start();
    });
});

$(document).ready(async function () {


    let queryString = window.location.href;
    let parametros = queryString.split("/");
    let historico = parametros[parametros.length - 1];

    if (historico != "" && historico != "create") {
        if ((await liberarRegistro("CADHISTORICO", historico)) == false) {
            window.location.href = "../cadhistorico";
        } else {
            try {
                $.LoadingOverlay("show");
                try {
                    let response = await requisicao(
                        "GET",
                        "/Sisplan/Funcoes/v1/pesquisa?",
                        `JSON={ "tabela":"HISTCP", 
                      "camposSelect":["DESCRICAO", "HISTORICO", "TIPO", "SITUACAO", "OBSERVACAO", "ID", "MODALIDADE", "CREDITO_GRUPO", "LIMITE_CREDITO"], "where": ["HISTORICO = '${historico}'"]}`,
                        null
                    );

                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgAlerta(jsonStr.RESULT[0].mensagem);
                        return;
                    }

                    if (jsonStr.RESULT[0][0].HISTORICO != '') {
                        $("#txtHistorico").prop('disabled', true);
                    }

                    $("#txtHistorico").val(jsonStr.RESULT[0][0].HISTORICO);
                    $("#txtDescricao").val(jsonStr.RESULT[0][0].DESCRICAO);
                    $("#txtObservacao").val(jsonStr.RESULT[0][0].OBSERVACAO);
                    $('#rgTipo').val(jsonStr.RESULT[0][0].TIPO);
                    $('#cbCreditoGrupo').prop('checked', jsonStr.RESULT[0][0].CREDITO_GRUPO == 'S');
                    $('#cbLimiteCredito').prop('checked', jsonStr.RESULT[0][0].LIMITE_CREDITO == 'S');
                    if (jsonStr.RESULT[0][0].SITUACAO == "P") {
                        $('#radioPendente').prop('checked', true);
                    }
                    if (jsonStr.RESULT[0][0].SITUACAO == "B") {
                        $('#radioBaixado').prop('checked', true);
                    }

                } catch (error) {
                    console.error(error);
                    msgAlerta(`Não foi possível buscar os dados:`);
                }
            } finally {
                $.LoadingOverlay("hide");
            }
        }
    }

    $("#txtDescricao").change(function () {
        $(this).val($(this).val().toUpperCase());
    });

    $('#txtHistorico').on('click', async function () {
        if ($('#txtHistorico').val() == '') {
            const historico = await RetornaProximo("HISTCP", "HISTCP", "HISTORICO", 2);
            $('#txtHistorico').val(historico);
            $('#txtHistorico').prop('disabled', true);
        }
        if (historico === 'create') {
            const historico = $('#txtHistorico').val();
            let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                `JSON={ "tabela":"HISTCP",
                    "camposSelect":["HISTORICO"], 
                    "where": ["HISTORICO = '${historico}'"]}`, null);

            let json = await response.json();
            if (json.RESULT[0].length > 0) {
                msgAlerta('Histórico já existe. Favor verifique!');
                return;
            }
        }
    });

    $("#btnVoltar").on("click", async function () {
        await deletaRegistro("CADHISTORICO", getCookie("usuario"), historico);
        window.location.href = `${BASE_URI}/cadhistorico`;
    });

    $("#gravar").click(async function () {
        let validator = $("#msform").validate();
        validator.form();
        let erros = 0;
        erros = validator.numberOfInvalids();

        if (erros == 0) {
            try {
                $.LoadingOverlay("show");

                if ($('#txtHistorico').val() === '') {
                    msgAlerta(`Necessário informar um histórico.`);
                    $.LoadingOverlay("hide");
                    return;
                }

                if ($('#txtDescricao').val() === '') {
                    msgAlerta(`Necessário informar uma descrição.`);
                    $.LoadingOverlay("hide");
                    return;
                }

                if ($('#rgTipo').val() === '') {
                    msgAlerta('Necessário informar um tipo.');
                    $.LoadingOverlay("hide");
                    return;
                }

                let HistoricoClasse = {};

                HistoricoClasse.HISTORICO = $('#txtHistorico').val();
                HistoricoClasse.DESCRICAO = $("#txtDescricao").val();
                HistoricoClasse.OBSERVACAO = $("#txtObservacao").val();
                HistoricoClasse.TIPO = $('#rgTipo').val();
                HistoricoClasse.CREDITO_GRUPO = $('#cbCreditoGrupo').prop('checked') ? 'S' : 'N';
                HistoricoClasse.LIMITE_CREDITO = $('#cbLimiteCredito').prop('checked') ? 'S' : 'N';
                if ($('#radioPendente').is(':checked')) {
                    HistoricoClasse.SITUACAO = 'P'
                }
                if ($('#radioBaixado').is(':checked')) {
                    HistoricoClasse.SITUACAO = 'B'
                }


                let response = await requisicao(
                    'POST', '/sisplan/cadastros/v1/cadhistorico?', '', JSON.stringify(HistoricoClasse), 15000
                );

                if (!response) {
                    $.LoadingOverlay("hide");
                    return;
                }

                if (response.status != 200) {
                    let jsonStr = await response.json();
                    $.LoadingOverlay("hide");
                    msgAlerta(jsonStr.mensagem);
                    return;
                }
                $.LoadingOverlay("hide");
                toastr
                    .success(
                        `Cadastro efetuado com sucesso!
                           Histórico: ${HistoricoClasse.HISTORICO}`,
                        "Confirmação",
                        {
                            toastClass: "alert",
                            iconClasses: {
                                error: "alert-error",
                                info: "alert-info",
                                success: "alert-success",
                                warning: "alert-warning",
                            },
                            positionClass: "toast-top-center",
                            progressBar: true,
                            timeOut: 3000,
                            fadeOut: 1000,
                            onHidden() {
                                window.location.href = `${BASE_URI}/cadhistorico`;
                            },
                        }
                    )
                    .css({
                        "margin-top": "20%",
                        width: "500px",
                        "max-width": "500px",
                    });
            } catch (error) {
                console.error(error);
                $.LoadingOverlay("hide");
                msgAlerta(`Não foi possível gravar os dados:`);
            }
        }
    });
});