$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
        });
        driver.defineSteps([{
            element: '#btnConfig',
            popover: {
                title: 'Botão Config.',
                description: 'Clique aqui para configurar o ini.',
                position: 'bottom'
            }
        },
        {
            element: '#txtChaveNfe',
            popover: {
                title: 'Campo Chave NF-e',
                description: 'Selecionar a chave da nota.',
                position: 'bottom'
            }
        },
        {
            element: '#tourbotoes',
            popover: {
                title: 'Campos',
                description: 'Aqui estão as informações da nota e dados para geração da GNRE.',
                position: 'bottom'
            }
        },
        {
            element: '#btnGerar',
            popover: {
                title: 'Botão Gerar',
                description: 'Clique aqui para gerar a GNRE.',
                position: 'top'
            }
        },
        {
            element: '#btnImprimir',
            popover: {
                title: 'Botão Imprimir',
                description: 'Clique aqui para Imprimir a GNRE.',
                position: 'top'
            }
        },
        {
            element: '#btnGerarAP',
            popover: {
                title: 'Botão Gerar AP',
                description: 'Clique aqui para gerar AP.',
                position: 'top'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {
    let queryString = window.location.href;
    let parametros = queryString.split("/");
    let notaUrl = parametros[parametros.length - 1];
    if (notaUrl != "create") {
        let chave = atob(parametros[parametros.length - 1]);
        await buscaDados(chave);
    }

    $('#txtClasse').autocompleta(1, `JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
    $('#txtFornecedor').autocompleta(3, `JSON={ "tabela":"entidade", "camposSelect":[ "codcli chave", "nome descricao"], "where": null}`);
    $('#txtSituacao').autocompleta(1, `JSON={ "tabela":"tabsit", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);
    $('#txtBanco').autocompleta(1, `JSON={ "tabela":"cadban", "camposSelect":[ "banco chave", "nome_banco descricao"], "where": null}`);
    $('#txtConta').autocompleta(1, `JSON={ "tabela":"cadconta", "camposSelect":[ "codigo chave", "descricao"], "where": null}`);

    $('#btn-Classe').pesquisa('#txtClasse', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"classe_ger", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Classe', 'classe_ger');
    $('#btn-Fornecedor').pesquisa('#txtFornecedor', 'CODCLI', 'NOME', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"entidade", "camposSelect":[ "codcli", "nome"]}`, 'Pesquisa Fornecedor', 'entidade');
    $('#btn-Situacao').pesquisa('#txtSituacao', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabsit", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Situação', 'tabsit');
    $('#btn-Banco').pesquisa('#txtBanco', 'BANCO', 'NOME_BANCO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadban", "camposSelect":[ "banco", "nome_banco"]}`, 'Pesquisa Banco', 'cadban');
    $('#btn-Conta').pesquisa('#txtConta', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"cadconta", "camposSelect":[ "codigo", "descricao"]}`, 'Pesquisa Conta', 'cadconta');

    $('#btn-limpa-Classe').on('click', function () {
        $('#txtClasse').val('');
    });
    $('#btn-limpa-Fornecedor').on('click', function () {
        $('#txtFornecedor').val('');
    });
    $('#btn-limpa-Situacao').on('click', function () {
        $('#txtSituacao').val('');
    });
    $('#btn-limpa-Banco').on('click', function () {
        $('#txtBanco').val('');
    });
    $('#btn-limpa-Conta').on('click', function () {
        $('#txtConta').val('');
    });

    const emp_id = getCookie('emp_id');
    $('#btn-ChaveNfe').pesquisa_serverside(['#txtChaveNfe', '#txtNome', '#txtEstado'],
        ['NOTA.CHAVE_NFE', 'NOTA.CODCLI', 'CIDADE.COD_UF'],
        ['NOTA.FATURA', 'ENTIDADE.NOME', 'CIDADE.COD_UF'],
        `{"tabela":"NOTA", "camposSelect":[ "NOTA.CHAVE_NFE", "NOTA.FATURA", "NOTA.SERIE", "NOTA.CODCLI", "ENTIDADE.NOME", "CIDADE.COD_UF"], 
                           "innerJoin":[{"tabela": "ENTIDADE", "condicao": "NOTA.CODCLI = ENTIDADE.CODCLI"},
                                        {"tabela": "CADCEP", "condicao": "CADCEP.CEP = ENTIDADE.CEP"},
                                        {"tabela": "CIDADE", "condicao": "CIDADE.CODIGO = CADCEP.CODMUN"}], 
                           "where": ["NOTA.EMP_ID = ${emp_id} AND (NOTA.GERAR_DIFAL = 'Sim' OR NOTA.VAL_ICMS_POBREZA > 0)"]}`, 'Pesquisa Nota');

    $("#btn-Estado").pesquisa(
        "#txtEstado",
        "CODIGO",
        "CODIGO",
        `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"tabuf", "camposSelect":[ "CODIGO", "DESCRICAO"]}`,
        "Pesquisa UF",
        "tabuf"
    );

    $("#btn-limpar-ChaveNfe").on("click", function () {
        $("#txtChaveNfe").val('');
    });

    $("#btn-limpar-Estado").on("click", function () {
        $("#txtEstado").val('');
    });

    $("#txtChaveNfe").on("focusout", async function () {
        buscaDados(pegaChave(this));
    });

    $(function () {
        $('#txtValor').maskMoney({
            decimal: ',',
            thousands: '.',
            precision: 2,
            allowZero: true,
            defaultZero: true,
            min: 0,
            max: 99
        });
    });

    await vencimentoCertificado();
    await retornaAmbiente();

    async function buscaDados(chave) {
        $.LoadingOverlay('show');
        try {
            if (chave == '') {
                return;
            }

            const filtros = `NOTA.CHAVE_NFE = '${chave}'`;

            const dadosSelect = {
                tabela: 'NOTA',
                camposSelect: [
                    'NOTA.FATURA',
                    'NOTA.CHAVE_NFE',
                    'NOTA.SERIE',
                    'NOTA.EMP_ID',
                    'NOTA.DT_EMISSAO',
                    'NOTA.VALOR',
                    'NOTA.VAL_ICMS_UF_DEST',
                    'NOTA.VAL_ICMS_POBREZA',
                    'CIDADE.COD_UF',
                    'CADCEP.CODMUN',
                    'NOTA.CODCLI',
                    'ENTIDADE.NOME',
                    'ENTIDADE.CNPJ',
                    'ENTIDADE.INSCRICAO',
                    'NOTA.VAL_SUBST'
                ],
                innerJoin: [
                    { tabela: 'ENTIDADE', condicao: 'ENTIDADE.CODCLI = NOTA.CODCLI' },
                    { tabela: 'CADCEP', condicao: 'CADCEP.CEP = ENTIDADE.CEP' },
                    { tabela: 'CIDADE', condicao: 'CIDADE.CODIGO = CADCEP.CODMUN' }],
                where: [filtros]
            };
            const retornoSelect = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelect));
            if (!retornoSelect) {
                msgAlerta('Não foi possível buscar os dados da nota.');
                return;
            }
            insereValor('#txtChaveNfe', retornoSelect[0].CHAVE_NFE, retornoSelect[0].FATURA);
            insereValor('#txtNome', retornoSelect[0].CODCLI, retornoSelect[0].NOME);
            insereValor('#txtFatura', retornoSelect[0].FATURA);
            insereValor('#txtSerie', retornoSelect[0].SERIE);
            insereValor('#txtDocumento', retornoSelect[0].FATURA.substring(1, 6));
            insereValor('#dtEmissaoNF', retornoSelect[0].DT_EMISSAO.slice(0, 10));
            insereValor('#txtEstado', retornoSelect[0].COD_UF, retornoSelect[0].COD_UF);
            insereValor('#txtCNPJCPF', retornoSelect[0].CNPJ);
            insereValor('#txtMunDest', retornoSelect[0].CODMUN.substring(retornoSelect[0].CODMUN.length - 5));
            insereValor('#txtValorNF', retornoSelect[0].VALOR.toFixed(2));
            insereValor('#txtValorDifal', retornoSelect[0].VAL_ICMS_UF_DEST.toFixed(2));
            insereValor('#txtValorPobreza', retornoSelect[0].VAL_ICMS_POBREZA.toFixed(2));
            insereValor('#txtValorST', !retornoSelect[0].VAL_SUBST ? 0 : retornoSelect[0].VAL_SUBST.toFixed(2));
            insereValor('#txtIEDestinatario', retornoSelect[0].INSCRICAO != 'ISENTO' ? retornoSelect[0].INSCRICAO : '');
            await setarDataAtual('dtVencimento');
            await setarDataAtual('dtPagamento');

            const filtroCep = `EMPRESA.EMP_ID = '${getCookie('emp_id')}'`;

            const dadosSelectCep = {
                tabela: 'EMPRESA',
                camposSelect: [
                    'CADCEP.CODMUN'
                ],
                innerJoin: [
                    { tabela: 'CADCEP', condicao: 'CADCEP.CEP = EMPRESA.EMP_CEP' }],
                where: [filtroCep]
            };
            const retornoSelectCep = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelectCep));
            if (!retornoSelectCep) {
                msgAlerta('Não foi possível buscar os dados da empresa.');
                return;
            }
            insereValor('#txtMunEmit', retornoSelectCep[0].CODMUN.substring(retornoSelectCep[0].CODMUN.length - 5));

            const filtroUFGnre = `UFGNRE.UF = '${pegaChave('#txtEstado')}' AND UFGNRE.EMP_ID = '${getCookie('emp_id')}'`;

            const dadosSelectUFGnre = {
                tabela: 'UFGNRE',
                camposSelect: [
                    'UFGNRE.REC_DIFAL',
                    'UFGNRE.DET_DIFAL',
                    'UFGNRE.PROD_DIFAL',
                    'UFGNRE.REC_POBRE',
                    'UFGNRE.DET_POBRE',
                    'UFGNRE.PROD_POBRE',
                    'UFGNRE.REC_ICMSST',
                    'UFGNRE.DET_ICMSST',
                    'UFGNRE.PROD_ICMSST'
                ],
                where: [filtroUFGnre]
            };
            const retornoSelectUFGnre = await retornaJsonPesquisaPadrao(JSON.stringify(dadosSelectUFGnre));
            if (!retornoSelectUFGnre) {
                msgAlerta('Não foi possível buscar os dados dos códigos UFGNRE.');
                return;
            }

            if (retornoSelectUFGnre[0]) {
                insereValor('#txtCodReceitaDifal', retornoSelectUFGnre[0].REC_DIFAL);
                insereValor('#txtDetalheDifal', retornoSelectUFGnre[0].DET_DIFAL);
                insereValor('#txtCodReceitaPobreza', retornoSelectUFGnre[0].REC_POBRE);
                insereValor('#txtDetalhePobreza', retornoSelectUFGnre[0].DET_POBRE);
                insereValor('#txtProdutoDifal', retornoSelectUFGnre[0].PROD_DIFAL);
                insereValor('#txtProdutoPobreza', retornoSelectUFGnre[0].PROD_POBRE);
                insereValor('#txtCodReceitaST', retornoSelectUFGnre[0].REC_ICMSST);
            } else {
                await carregaValoresPadroes()
                $('#txtProdutoDifal').val('');
                $('#txtProdutoPobreza').val('');
                $('#txtCodReceitaST').val('');
            }
            $('.maskDecimais').trigger('blur');
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function carregaValoresPadroes() {
        const jsonStr = await buscaValoresPadroes('NOTA')

        jsonStr.map(async item => {
            switch (item.CAMPO) {
                case 'RECEITA_DIFAL': {
                    $('#txtCodReceitaDifal').val(item.VALOR)
                    break;
                }
                case 'DETALHE_DIFAL': {
                    $('#txtDetalheDifal').val(item.VALOR)
                    break;
                }
                case 'RECEITA_POBREZA': {
                    $('#txtCodReceitaPobreza').val(item.VALOR)
                    break;
                }
                case 'DETALHE_POBREZA': {
                    $('#txtDetalhePobreza').val(item.VALOR)
                    break;
                }
                default: {
                    break;
                }
            }
        });
    }

    $('#btnConfig').on('click', async function () {
        try {
            const url = '/sisplan/gnre/v1/buscarinignre?';
            const params = '';
            const response = await requisicao('GET', url, params, null);

            const jsonIni = await response.json();
            if (response.status != 200) {
                console.log(jsonIni.RESULT[0][0].mensagem);
                return;
            }
            $('#txtDiretorioLog').val(jsonIni.diretorioLog);

            if (jsonIni.ambiente == '2') {
                $('#txtAmbiente').val('2');
            } else {
                $('#txtAmbiente').val('1');
            }
        } finally {
            $('#modal-config').modal('show');
        }
    });

    $('#btnGerarAP').on('click', async function () {
        if (await validaPagar()) {
            await dadosPagar();
            $('#modal-pagar').modal('show');
        }
    });

    $('#btnGravarPagar').on('click', async function () {
        await gravaPagar();
    });

    $('#btnGerar').on('click', async function () {
        await gerarGNRE();
    });

    $('#btnConfirmarConfigGNRE').on('click', async function () {
        try {
            const params = '';
            const NFE = {
                ambiente: $('#txtAmbiente').val(),
                diretorioLog: $('#txtDiretorioLog').val()
            };
            const url = '/sisplan/gnre/v1/gravarinignre?';
            const response = await requisicao('POST', url, params, JSON.stringify(NFE), 15000);
            console.log(response);


            if (response.status == 200) {
                toastr.success(
                    'Configuração gravada com sucesso!',
                    'Confirmação', {
                    toastClass: 'alert',
                    iconClasses: {
                        error: 'alert-error',
                        info: 'alert-info',
                        success: 'alert-success',
                        warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        $('#modal-config').modal('hide');
                    }
                }
                ).css({
                    "margin-top": "20%",
                    "width": "500px",
                    "max-width": "500px"
                });
            } else {
                return;
            }
        } finally {
            $('#modal-config').modal('hide');
        }
        await retornaAmbiente();
    });

    function retornaGNRE() {
        let resultado = [];
        const gnre = {
            CHAVE_NFE: pegaChave('#txtChaveNfe'),
            CIDADE_DEST: $('#txtMunDest').val(),
            CIDADE_EMITENTE: $('#txtMunEmit').val(),
            CNPJ_DESTINATARIO: $('#txtCNPJCPF').val(),
            CODREC_DIFAL: $('#txtCodReceitaDifal').val(),
            CODREC_POBREZA: $('#txtCodReceitaPobreza').val(),
            CODREC_ST: $('#txtCodReceitaST').val(),
            DETALHE_DIFAL: $('#txtDetalheDifal').val(),
            DETALHE_POBREZA: $('#txtDetalhePobreza').val(),
            DOCUMENTO: $('#txtDocumento').val(),
            DT_EMISSAO: `${$('#dtEmissaoNF').val()}T00:00:00Z`,
            DT_PAGAMENTO: `${$('#dtPagamento').val()}T00:00:00Z`,
            DT_VENCIMENTO: `${$('#dtVencimento').val()}T00:00:00Z`,
            ESTADO: pegaChave('#txtEstado'),
            FATURA: pegaDescricao('#txtChaveNfe'),
            IE_DESTINATARIO: $('#txtIEDestinatario').val(),
            NOME: pegaDescricao('#txtNome'),
            PRODUTO_DIFAL: $('#txtProdutoDifal').val(),
            PRODUTO_POBREZA: $('#txtProdutoPobreza').val(),
            SERIE: $('#txtSerie').val(),
            VAL_DIFAL: parseFloat($('#txtValorDifal').val().replace(',', '.')),
            VAL_POBREZA: parseFloat($('#txtValorPobreza').val().replace(',', '.')),
            VAL_ST: parseFloat($('#txtValorST').val().replace(',', '.')),
            VALOR: parseFloat($('#txtValorNF').val().replace(',', '.'))
        };
        resultado.push(gnre);

        return gnre;
    };

    async function gravaPagar() {
        try {
            $.LoadingOverlay("show");
            try {
                if ((parseFloat($('#txtValor').val()) <= 0) || ($('#txtValor').val() == "0,00")) {
                    msgAlerta('Valor não pode ser 0!');
                    return;
                }

                const classe = pegaChave('#txtClasse');
                const situacao = pegaChave('#txtSituacao');
                const fornecedor = pegaChave('#txtFornecedor');
                const banco = pegaChave('#txtBanco');
                const conta = pegaChave('#txtConta');

                if ((classe == '') || (banco == '') || (conta == '') || (situacao == '') || (fornecedor == '')) {
                    msgAlerta('Campos obrigatórios não informados.');
                    return;
                }
                let PagarC = {};

                PagarC.NUM_AP = $('#txtNum_ap').val();
                PagarC.DOCTO = $('#txtNotaFiscal').val();
                PagarC.LANCAMENTO = $('#txtLancamento').val();
                PagarC.VALOR = parseFloat($('#txtValor').val());
                PagarC.VAL_PAG = parseFloat(0);
                PagarC.VAL_NOTA = parseFloat($('#txtValor').val());
                PagarC.VALOR_ORIG = parseFloat($('#txtValor').val());
                PagarC.DT_VEN = `${$('#txtDTvencimento').val()}T00:00:00Z`;
                PagarC.DATA_ORIG = `${$('#txtDTvencimento').val()}T00:00:00Z`;
                PagarC.DT_EMI = `${$('#txtDTemissao').val()}T00:00:00Z`;
                PagarC.STATUS = $('#txtStatus').val();
                PagarC.OBS = $('#txtObs').val();
                PagarC.EMP_ID = $('#txtEmpId').val();
                PagarC.CODCRE = fornecedor;
                PagarC.SITUACAO = situacao;
                PagarC.NUM_OS = classe;
                PagarC.BANCO = banco;
                PagarC.CONTA = conta;
                PagarC.TELA = "GNRE";

                let response = await requisicao(pagar = 'POST', '/Sisplan/pagar/V1/Pagar?', '', `JSON=${encodeURIComponent(JSON.stringify(PagarC))}`);

                if (!response) {
                    return;
                }

                let jsonStr = await response.json();

                if (response.status == 502) {
                    await msgAguardaConfirmacao(jsonStr.mensagem, () => { }, () => { }, false, true, "Continuar");
                } else if (response.status != 200) {
                    msgErro(jsonStr.mensagem);
                    return;
                }
                $.LoadingOverlay("hide");
                toastr.success(
                    'AP gerada com sucesso!',
                    'Confirmação', {
                    toastClass: 'alert',
                    iconClasses: {
                        error: 'alert-error',
                        info: 'alert-info',
                        success: 'alert-success',
                        warning: 'alert-warning'
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        deletaRegistro('PAGAR', getCookie('usuario'), PagarC.NUM_AP);
                    }
                }
                ).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px"
                });
            } catch (error) {
                console.error(error);
                msgErro('Não foi possível gravar os dados do Pagamento: ');
            }
            $('#modal-pagar').modal('hide');
        } finally {
            $.LoadingOverlay('hide');
        }
    }

    async function validaPagar() {
        $.LoadingOverlay('show');
        try {
            response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?', `JSON={ "tabela":"PAGTO", "camposSelect":["PAGTO.NUM_AP"], "where": ["PAGTO.OBS = 'Ref. GNRE da nota de chave:${pegaChave('#txtChaveNfe')}'"]}`, null);

            if (!response) {
                return true;
            }
            jsonStr = await response.json();
            if (response.status != 200) {
                return true;
            }
            try {
                const num_ap = jsonStr.RESULT[0][0].NUM_AP;
                if (num_ap != '') {
                    msgAlerta(`Já existe uma AP para esta chave de nota gerada atraves do GNRE. Número AP: ${num_ap}`);
                    return false;
                }
            } catch {
                return true;
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    async function dadosPagar() {
        $('#txtStatus').val('DUPL');
        insereValor('#txtValor', parseFloat($('#txtValorDifal').val().replace(',', '.')) + parseFloat($('#txtValorPobreza').val().replace(',', '.')));
        $('#txtObs').val(`Ref. GNRE da nota de chave:${pegaChave('#txtChaveNfe')}`);
        $('#txtNotaFiscal').val(`${$('#txtDocumento').val()}`);
        setarDataAtual('txtDTemissao');
        $('#txtDTvencimento').val(`${$('#dtVencimento').val()}`);

        response = await requisicao('GET', '/sisplan/funcoes/v1/pesquisa?',
            `JSON={ "tabela":"TABUF", "camposSelect":["TABUF.CODIGO", "GNRE_CONF.CODCLI", "ENTIDADE.NOME"], 
            "leftJoin": [{ "tabela" : "GNRE_CONF", "condicao" : "GNRE_CONF.UF = TABUF.CODIGO" }, { "tabela" : "ENTIDADE", "condicao" : "ENTIDADE.CODCLI = GNRE_CONF.CODCLI" }], 
            "where": ["TABUF.CODIGO = '${pegaChave('#txtEstado')}'"]}`, null
        );

        if (response) {
            jsonStr = await response.json();
            if (response.status == 200) {
                if (jsonStr.RESULT[0][0].CODCLI != '') {
                    insereValor('#txtFornecedor', jsonStr.RESULT[0][0].CODCLI, jsonStr.RESULT[0][0].NOME);
                }
            }
        }
    };

    async function gerarGNRE() {
        $.LoadingOverlay('show');
        try {
            if (pegaChave('#txtChaveNfe') == '') {
                msgAlerta('Necessário selecionar uma nota.');
                $.LoadingOverlay('hide');
                return;
            };

            const gnre = retornaGNRE();

            const response = await requisicao('POST', '/sisplan/gnre/v1/gerargnre?', '', JSON.stringify(gnre), 90000);

            if (!response) {
                $.LoadingOverlay('hide');
                return;
            }

            if (response.status != 200) {
                const jsonStr = await response.json();
                $.LoadingOverlay('hide');
                msgAlerta(jsonStr.mensagem);
                return;
            }

            $.LoadingOverlay('hide');
            await criaMensagemSucesso('GNRE gerada com sucesso!', () => {
                $('#btnImprimir').trigger('click');
            });
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
            msgAlerta(`Não foi possível gerar GNRE: ${error}`);
        }
    };

    $('#btnImprimir').on('click', async function () {
        const gnre = retornaGNRE();
        var url = `/sisplan/gnre/v1/imprimirgnre?FATURA=${gnre.FATURA}&SERIE=${gnre.SERIE}`;
        try {
            $.LoadingOverlay("show");
            try {
                const bImprimeAutomatico = await verificaImprimirAutomatico('GNRE');
                const arquivo = await GeraRelatorio(url + '&', 'PUT', 150000, false, 'GNRE');
                if (arquivo != undefined) {
                    if (!bImprimeAutomatico) {
                        window.open(BASE_URI + '/relatorios_api/pdf/' + arquivo, '_blank');
                    }
                    await limparRelatorios();
                }
            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    });

    async function retornaAmbiente() {
        try {
            let response = await requisicao('GET', '/sisplan/gnre/v1/retornaambiente?', '');
            if (!response) {
                return;
            }
            let jsonStr = await response.json();

            if (jsonStr.mensagem == '1') {
                $("#txtAmbienteInf").css("color", "green");
                $("#txtAmbienteInf")[0].textContent = "AMBIENTE: PRODUÇÃO";
            } else {
                $("#txtAmbienteInf").css("color", "red");
                $("#txtAmbienteInf")[0].textContent = "AMBIENTE: HOMOLOGAÇÃO";
            }
        } catch (error) {
            console.error(error);
        }
    }
})