$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true
        });

        driver.defineSteps([{
            element: '#campostuto',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: '#txtCodigo',
            popover: {
                title: 'Código',
                description: 'O campo de código é preenchido automaticamente após gravar o registro.',
                position: 'top'
            }
        },
        {
            element: '#txtDescricao',
            popover: {
                title: 'Descrição',
                description: 'Neste campo adicionamos a descrição para o grupo cor.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar o Grupo de Cor.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {


    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('GRUPOCOR', getCookie('usuario'), grupocor);
        window.location.href = `${BASE_URI}/grupocor`;
    });

    $(document).ready(function () {

        $('#txtCodigo').prop('disabled', true);

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtDescricao: {
                    required: true,
                },
            },
            messages: {
                txtDescricao: {
                    required: "Informe uma descrição válida."
                },
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let grupocor = parametros[parametros.length - 1];

    if (grupocor != '' && grupocor != 'create') {

        if (await liberarRegistro('GRUPOCOR', grupocor) == false) {
            window.location.href = '../grupocor';
        } else {

            try {
                $.LoadingOverlay("show");
                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"grupo_cor", 
                    "camposSelect":["codigo", "descricao", "separador", "inserir_no"], 
                    "where": ["codigo = '${grupocor}'"]}`, null);

                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    }

                    $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
                    $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);
                    $('#txtSeparador').val(jsonStr.RESULT[0][0].SEPARADOR);
                    $(`input[value="${jsonStr.RESULT[0][0].INSERIR_NO}"]`).prop('checked', true);

                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados do tamanho: ${error}`);
                }
            } finally {
                $.LoadingOverlay('hide');
            }
        }
    };

    $("#gravar").click(

        async function () {

            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {
                try {
                    $.LoadingOverlay("show");

                    let grupocorClasse = {};
                    grupocorClasse.CODIGO = $('#txtCodigo').val() == '' ? await RetornaProximo('grupo_cor', 'grupo_cor', 'CODIGO', 3) : $('#txtCodigo').val();
                    grupocorClasse.DESCRICAO = $('#txtDescricao').val().toUpperCase();
                    grupocorClasse.SEPARADOR = $('#txtSeparador').val();

                    if ($('#radioInicio').is(':checked')) {
                        grupocorClasse.INSERIRNO = 'I';
                    }
                    if ($('#radioFinal').is(':checked')) {
                        grupocorClasse.INSERIRNO = 'F';
                    }
                    if ($('#radioNaoUsar').is(':checked')) {
                        grupocorClasse.INSERIRNO = 'N';
                    }

                    let response = await requisicao('POST', '/Sisplan/Cadastros/v1/grupocor?', `JSON=${encodeURIComponent(JSON.stringify(grupocorClasse))}`, null);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        `Cadastro efetuado com sucesso!
                        Grupo de cor: ${grupocorClasse.CODIGO}`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/grupocor`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });

                } catch (error) {
                    console.error(error);
                    $.LoadingOverlay("hide");
                    msgErro(`Não foi possível gravar os dados do tamanho: ${error}`);
                }
            }
        });
});