$("#tutorial").on("click", function () {
  $(document).ready(async function () {
    const driver = new Driver({
      doneBtnText: "Sair",
      closeBtnText: "Fechar",
      nextBtnText: "Próximo",
      prevBtnText: "Anterior",
      allowClose: false,
      animate: true,
    });
    driver.defineSteps([
      {
        element: "#campostour",
        popover: {
          title: "Dados Gerais",
          description:
            "Aqui estão os campos disponíveis para realizar a movimentação.",
          position: "top",
        },
      },
      {
        element: "#txtDocumento",
        popover: {
          title: "Campos Obrigatórios",
          description:
            "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtTipoSaida",
        popover: {
          title: "Campos Obrigatórios",
          description:
            "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtQualidade",
        popover: {
          title: "Campos Obrigatórios",
          description:
            "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtDeposito",
        popover: {
          title: "Campos Obrigatórios",
          description:
            "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtProduto",
        popover: {
          title: "Campos Obrigatórios",
          description:
            "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#txtCor",
        popover: {
          title: "Campos Obrigatórios",
          description:
            "Esse é um campo obrigatório, para identificá-los, você verá um * ao lado do nome.",
          position: "top",
        },
      },
      {
        element: "#confirmar_mov",
        popover: {
          title: "Botão Gravar",
          description: "Clique aqui para gravar a movimentação.",
          position: "left",
        },
      },
    ]);
    driver.start();
  });
});

$(document).ready(async function () {
  const parametrosVenda = await BuscaParametrosVenda();
  let listaBarrasBipadas = [];
  let barraNaoEncontrada = [];
  let bRFID = false;
  let bRFIDAbort = false;
  const parametrosSistema = await BuscaParametrosSistema();
  const utilizaBarraLog = parametrosSistema[0].VALOR != 0;
  const depositoParam = parametrosVenda[1];
  const bUsaIntegraçãoITAG = parametrosVenda[60] == 1;
  const bProduto = parametrosVenda[17] == 0;
  const bApenasBarraLog = parametrosVenda[46] == 3;

  let codigoEntradaLoja = '';
  await carregaValoresPadroes();

  async function carregaTipoMovimento() {
    const pesquisaParam = {
      tabela: 'TABBAI',
      camposSelect: ['CODIGO', 'DESCRICAO', 'TIPO', 'ATIVO'],
      where: [`ATIVO = 'S'`],
    }
    const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

    let codigoEntrada = '';

    jsonStr.forEach(tipoMovimento => {
      if (tipoMovimento.TIPO && tipoMovimento.TIPO.charAt(18) === 'S') {
        codigoEntrada += codigoEntrada ? `,'${tipoMovimento.CODIGO}'` : `'${tipoMovimento.CODIGO}'`;
      }
    });

    codigoEntradaLoja = codigoEntrada;
  }

  await carregaTipoMovimento();

  if (bProduto) {
    $("#radioProduto").prop("checked", true);
    $('#divQualidade').removeClass('d-none')
  } else {
    $("#radioMaterial").prop("checked", true);
    $('#divQualidade').addClass('d-none')
  }

  // const depositoPadrao = await BuscaDepositoPadrao();
  $('#txtDeposito').val(depositoParam);

  $('#txtNota').prop('disabled', true);
  $('#btnNota').prop('disabled', true);
  $('#btnANota').prop('disabled', true);
  let urlTransferencia = "";
  let paramsTransferencia = "";
  let documentoGlobal = '';
  let objetoTransferencia = {};
  let tabelasUnificadas = true;
  let empPesquisa = getCookie('empresa');
  let confirmaNaoEhTIpoEntradaLoja = false

  $('#checkNotasEntradaEmpLogada, #checkNotasEntradaConferidas').on('change', async () => {
    await alteraConsultaNotasEntrada();
  });

  $("#radioNormal, #radioTransf, #radioNotaEntra").on("change", async function () {
    $('#txtEmpresa').val('')
    if ($("#radioNormal").is(":checked")) {
      $("#divNota").removeClass("d-none");
      $("#divEstoqueSaida").addClass("d-none");
      $("#divNotaEntra").addClass("d-none");
      $("#divNotasEntrada").addClass("d-none");
      localStorage.setItem("@conf_filiais.tipo_conferencia", "normal");
    } else if ($('#radioNotaEntra').is(':checked')) {
      $('#divNota').addClass('d-none');
      $('#divNotaEntra').removeClass('d-none');
      $('#divNotasEntrada').removeClass('d-none');
      $("#divEstoqueSaida").addClass("d-none");

      $('#divNotas').addClass('d-none');
    } else {
      $("#divNota").addClass("d-none");
      $("#divNotaEntra").addClass("d-none");
      $("#divNotasEntrada").addClass("d-none");
      $("#divEstoqueSaida").removeClass("d-none");
      localStorage.setItem("@conf_filiais.tipo_conferencia", "transferencia");
    }
    filtroTipo($("#radioProduto").prop("checked"));
    $('#btn-limpa-documento').trigger('click');
  });

  $("#radioProduto, #radioMaterial").on("change", async function () {
    if ($("#radioProduto").is(":checked")) {
      filtroTipo(true);
      localStorage.setItem("@conf_filiais.tipo_item", "produto");
      $('#divQualidade').removeClass('d-none')
    } else {
      filtroTipo(false);
      localStorage.setItem("@conf_filiais.tipo_item", "material");
      $('#divQualidade').addClass('d-none')
    }
    await alteraConsultaNotasEntrada();
  });

  async function retornaEmpId(empPat) {
    const url = `/sisplan/funcoes/v1/pesquisa?`;
    const response = await requisicao('GET', url, `JSON={ "tabela":"EMPRESA", "camposSelect":["EMP_ID"], "where": ["EMP_PAT = '${empPat}'"]}`, null);
    const jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.RESULT[0].mensagem);
      return;
    }
    return jsonStr.RESULT[0][0].EMP_ID;
  }

  async function carregaValoresPadroes() {
    const jsonStr = await buscaValoresPadroes('ESTOQUE')

    jsonStr.map(item => {
      switch (item.CAMPO) {
        case 'TIPO': {
          if (item.VALOR != '') {
            insereValor('#txtTpMovimento', item.VALOR, { tabela: 'TABBAI', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'DEPOSITO': {
          if (item.VALOR != '') {
            insereValor('#txtDeposito', item.VALOR, { tabela: 'DEPOSITO', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'QUALIDADE': {
          if (item.VALOR != '') {
            insereValor('#txtQualidade', item.VALOR, { tabela: 'TABQUL', campoBusca: 'DESCRICAO', campoWhere: 'CODIGO', valorWhere: item.VALOR });
          }
          break;
        }
        case 'TIPO_CONFERENCIA': {
          if (item.VALOR.toUpperCase() == 'N') {
            $("#radioNormal").click().trigger("change");
            $('#radioTransf').prop('disabled', true);
          } else if (item.VALOR.toUpperCase() == 'T') {
            $("#radioTransf").click().trigger("change");
            $('#radioNormal').prop('disabled', true);
          }
          break;
        }
        //Se for cadastrado no Valores Padrões o campo, vai subistituir o que está salvo no TIPO
        case 'MOV_IMPORTACAO': {
          if (item.VALOR != '') {
            insereValor('#txtTpMovimento', item.VALOR, item.COD_MOV);
          }
          break;
        }
      }
    });
  };


  const tipoConferenciaCookie = localStorage.getItem(
    "@conf_filiais.tipo_conferencia"
  );
  const tipoItemCookie = localStorage.getItem(
    "@conf_filiais.tipo_item"
  );
  if (tipoConferenciaCookie === "transferencia") {
    $("#radioTransf").click().trigger("change");
  } else {
    $("#radioNormal").click().trigger("change");
  }
  // if (tipoItemCookie === "material") {
  //   $("#radioMaterial").click().trigger("change");
  // } else {
  //   $("#radioProduto").click().trigger("change");
  // }

  $("#CampoConferencia").hide();
  $("#CampoConferenciaQtde").hide();
  $('#btnSom').addClass('d-none');

  if (await CopiaParametro('VENDA', 44) == 1) {
    $('#PesquisabarraProduto').show();
  } else {
    $('#PesquisabarraProduto').hide();
  }

  if (!(await VerificaReplicacao())) {
    $("#NomeTela").text("Conferência entre Filiais");
  }

  $("#txtQualidade").autocompleta(1, `JSON={ "tabela":"tabqul", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": [] }`, [], [], []);
  $("#btnQualidade").pesquisa_array(["#txtQualidade"], ["CODIGO"], ["DESCRICAO"], '/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"tabqul", "camposSelect":[ "codigo", "descricao" ], "where": null}', "Pesquisa Qualidade", "tabqul");
  $("#btnLimpaQualidade").on("click", function () {
    $("#txtQualidade").val("");
  });

  $('#txtTpMovimento').autocompleta(1, `JSON={ "tabela":"tabbai", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": ["ATIVO = 'S'"] }`, [], [], []);
  $('#btnTpMovimento').on('click', function () {
    if (!codigoEntradaLoja) {
      msgErro('Não existe Tipo Movimento cadastrada como Entrada Loja na tela "Tipo Baixa" para essa consulta.');
      return;
    }

    $('#btnTpMovimento').pesquisa_array(['#txtTpMovimento'], ['CODIGO'], ['DESCRICAO'], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"TABBAI", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["CODIGO IN (${codigoEntradaLoja})"]}`, 'Pesquisa Tipo Entrada', 'TABBAI');
  });


  $('#btnLimpaTpMovimento').on('click', function () {
    $('#txtTpMovimento').val('');
  });

  $('#txtTpMovimento').blur(
    async function () {
      let tipo = pegaChave('#txtTpMovimento');
      const pesquisaParam = {
        tabela: 'TABBAI',
        camposSelect: ['CODIGO', 'DESCRICAO', 'TIPO', 'ATIVO'],
        where: [`CODIGO ='${tipo}' AND ATIVO = 'S'`],
      }
      const jsonStr = await retornaJsonPesquisaPadrao(JSON.stringify(pesquisaParam));

      if (!(jsonStr[0].TIPO.charAt(18) === 'S')) { //18 = Entrada Loja
        try {
          await msgAguardaConfirmacao(
            `Tipo de movimentação não configurado para "Entrada Loja" na tela "Tipo de Baixa". Deseja continuar?`, async function () {
              confirmaNaoEhTIpoEntradaLoja = true;
            }, () => {
              $('#txtTpMovimento').val('')
            }, true
          )
        } catch (err) {
          console.error(err);
          $('#txtTpMovimento').val('')
          confirmaNaoEhTIpoEntradaLoja = false;
        }
      }
    }
  )

  $("#btnANotaEntra").on("click", function () {
    $("#txtNotaEntra").val("");
  });

  await alteraConsultaNotasEntrada();

  filtroTipo($("#radioProduto").prop("checked"));
  $("#btn-limpa-documento").on("click", function () {
    $("#txtDocumento").val("");
  });

  $("#btnBarraProduto").pesquisa_serverside(["#txtConferencia"], ["BARRA"], ["BARRA"], '{"tabela":"pa_iten", "camposSelect":[ "CODIGO", "COR", "TAM", "BARRA" ], "where": null}', "Pesquisa de Produto", LocalizaBarraGridPesquisa);

  const depositosEmpresaLogada = await verificaDepositosEmpresaLogada(getCookie('empresa'));

  if (depositosEmpresaLogada != '') {
    $("#txtDeposito").autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": ["CODIGO IN (${depositosEmpresaLogada})"] }`, [], [], []);
    $("#btnDeposito").pesquisa_array(["#txtDeposito"], ["CODIGO"], ["DESCRICAO"], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["CODIGO IN (${depositosEmpresaLogada})"]}`, "Pesquisa Depósito", "DEPOSITO");
  } else {
    $("#txtDeposito").autocompleta(1, `JSON={ "tabela":"DEPOSITO", "camposSelect":["CODIGO CHAVE, DESCRICAO"], "where": ["EMPRESA = '${getCookie('empresa').replace('_', '')}'"] }`, [], [], []);
    $("#btnDeposito").pesquisa_array(["#txtDeposito"], ["CODIGO"], ["DESCRICAO"], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"DEPOSITO", "camposSelect":[ "CODIGO", "DESCRICAO" ], "where": ["EMPRESA = '${getCookie('empresa').replace('_', '')}'"]}`, "Pesquisa Depósito", "DEPOSITO");
  }

  $("#btnLimpaDeposito").on("click", function () {
    $("#txtDeposito").val("");
  });

  $("#txtEmpresa").autocompleta(1, `JSON={ "tabela":"empresa", "camposSelect":["emp_pat CHAVE, EMP_NOME descricao"], "where": [] }`, [], [], []);
  $("#btnEmpresa").pesquisa_array(["#txtEmpresa"], ["EMP_PAT"], ["EMP_NOME"], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"empresa", "camposSelect":[ "EMP_PAT", "EMP_NOME", "EMP_CNPJ", "EMP_FANTASIA" ], "where": null}`, "Pesquisa Empresa", "empresa");
  $("#btnAEmpresa").on("click", function () {
    $("#txtEmpresa").val("");
    $('#divNotas').addClass('d-none');
  });
  $("#btnANota").on("click", function () {
    $("#txtNota").val("");
  });

  $("#txtCredorNota").autocompleta(1, `JSON={ "tabela":"ENTIDADE", "camposSelect":["COCLI CHAVE, NOME DESCRICAO"], "where": ["ENTIDADE.TIPO_ENTIDADE LIKE '[PERCENTUAL]F[PERCENTUAL]'"] }`, [], [], []);
  $("#btnCredorNota").pesquisa_array(["#txtCredorNota"], ["CODCLI"], ["NOME"], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"ENTIDADE", "camposSelect":[ "CODCLI", "NOME", "CNPJ", "FANTASIA" ], "where": ["ENTIDADE.TIPO_ENTIDADE LIKE '[PERCENTUAL]F[PERCENTUAL]'"]}`, "Pesquisa Credor", "ENTIDADE");
  $("#btnACredorNota").on("click", function () {
    $("#txtCredorNota").val("");
  });

  $("#btnAEmpresa").on("click", function () {
    $("#txtEmpresa").val("");
    $('#txtNota').val('');
    $('#btnNota').val('');
    $('#btnANota').val('');
    $('#txtNota').prop('disabled', true);
    $('#btnNota').prop('disabled', true);
    $('#btnANota').prop('disabled', true);
  });

  $('#btnRFID').on('click', function () {
    $("#btnConfirmarRFID").prop('disabled', false);
    $('#modal-RFID').modal('show');
  });

  $('#btnConfirmarRFID').on('click', async function () {
    $.LoadingOverlay("show");
    try {
      $("#btnConfirmarRFID").prop('disabled', true);
      await buscaDadosRFID();
      $('#modal-RFID').modal('hide');
      $("#btnConfirmarRFID").prop('disabled', false);
      $.LoadingOverlay("hide");
      if (barraNaoEncontrada.length > 0) {
        msgAlerta(`Barras não encontradas: ${barraNaoEncontrada.join(', ')}`);
        zeraQtdeConf();
      } else if (bRFIDAbort) {
        zeraQtdeConf();
      }
    } catch (error) {
      $.LoadingOverlay("hide");
      console.error(error);
      if (barraNaoEncontrada.length > 0) {
        msgAlerta(`Barras não encontradas: ${barraNaoEncontrada.join(', ')}`);
        zeraQtdeConf();
      } else if (bRFIDAbort) {
        zeraQtdeConf();
      }
    }
  });

  $('#btnCancelarRFID').on('click', function () {
    //validar qual será a rotina
    $('#modal-RFID').modal('hide');
    $("#btnRFID").removeClass("d-none");
  });

  async function validaTabelasUnificadas(empId, empPat) {
    try {
      const response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
        `JSON={ "tabela":"NOTA",
            "camposSelect":["FATURA"],
            "where": ["EMP_ID = '${empId}'"]}&EMPRESA=${empPat}`, null);
      if ((!response) || (response.status != 200)) {
        return;
      }
      const jsonStr = await response.json();

      if (jsonStr.RESULT[0].length > 0) {
        tabelasUnificadas = false;
      }
    } catch (error) {
      tabelasUnificadas = true;
    }
  }

  $('#txtEmpresa').on('blur', async function () {
    $.LoadingOverlay('show');
    try {

      const empresa = pegaChave('#txtEmpresa');

      empPesquisa = empresa;

      if (empresa == '') {
        $('#divNotas').addClass('d-none');
        return;
      }
      const empId = await retornaEmpId(empresa);

      await validaTabelasUnificadas(empId, empresa);

      $('#txtNota').prop('disabled', false);
      $('#btnNota').prop('disabled', false);
      $('#btnANota').prop('disabled', false);

      $("#btnNota").unbind();

      if (tabelasUnificadas) {
        $("#txtNota").autocompleta(1, `JSON={ "tabela":"NOTA", "camposSelect":[ "FATURA chave", "SERIE descricao"], "where": ["EMP_ID = ${empId}", "NOT EXISTS (SELECT NF_CONF_ENTRA.NUMERO FROM [NF_CONF_ENTRA] NF_CONF_ENTRA WHERE NOTA.FATURA = NF_CONF_ENTRA.NUMERO AND NOTA.SERIE = NF_CONF_ENTRA.SERIE AND NOTA.EMP_ID = NF_CONF_ENTRA.EMP_ID_ORIGEM)"]}`);
        $('#btnNota').pesquisa_serverside(['#txtNota'], ['FATURA'], ['SERIE'], `{"tabela":"NOTA", "camposSelect":[ "FATURA", "SERIE" ],  "where": ["EMP_ID = ${empId}", "NOT EXISTS (SELECT NF_CONF_ENTRA.NUMERO FROM [NF_CONF_ENTRA] NF_CONF_ENTRA WHERE NOTA.FATURA = NF_CONF_ENTRA.NUMERO AND NOTA.SERIE = NF_CONF_ENTRA.SERIE AND NOTA.EMP_ID = NF_CONF_ENTRA.EMP_ID_ORIGEM)"]}`, "Pesquisa Nota");
      } else {
        $("#txtNota").autocompleta(1, `JSON={ "tabela":"NOTA", "camposSelect":[ "FATURA chave", "SERIE descricao"], "where": ["EMP_ID = ${empId}", "NOT EXISTS (SELECT NF_CONF_ENTRA.NUMERO FROM [NF_CONF_ENTRA] NF_CONF_ENTRA WHERE NOTA.FATURA = NF_CONF_ENTRA.NUMERO AND NOTA.SERIE = NF_CONF_ENTRA.SERIE AND NOTA.EMP_ID = NF_CONF_ENTRA.EMP_ID_ORIGEM)"]}`, undefined, undefined, undefined, undefined, undefined, empresa.replace('_', ''));
        $('#btnNota').pesquisa_serverside(['#txtNota'], ['FATURA'], ['SERIE'], `{"tabela":"NOTA", "camposSelect":[ "FATURA", "SERIE" ],  "where": ["EMP_ID = ${empId}", "NOT EXISTS (SELECT NF_CONF_ENTRA.NUMERO FROM [NF_CONF_ENTRA] NF_CONF_ENTRA WHERE NOTA.FATURA = NF_CONF_ENTRA.NUMERO AND NOTA.SERIE = NF_CONF_ENTRA.SERIE AND NOTA.EMP_ID = NF_CONF_ENTRA.EMP_ID_ORIGEM)"]}`, "Pesquisa Nota", undefined, undefined, empresa);
      }

      $('#divNotas').removeClass('d-none');
      $('#checkNotasEmpLogada, #checkNotasConferidas').prop('checked', false);
    } finally {
      $.LoadingOverlay('hide');
    }
  });

  $('#checkNotasEmpLogada, #checkNotasConferidas').on('change', async function () {
    alteraConsultaNotas();
  });

  async function alteraConsultaNotas() {
    try {
      setTimeout(async () => {
        if (!$('#checkNotasEmpLogada').prop('checked') && !$('#checkNotasConferidas').prop('checked')) {
          $('#txtEmpresa').trigger('blur');
          return;
        }

        const empresa = pegaChave('#txtEmpresa');

        empPesquisa = empresa;

        if (empresa == '') {
          $('#divNotas').addClass('d-none');
          return;
        }
        const empId = await retornaEmpId(empresa);

        $('#txtNota').prop('disabled', false);
        $('#btnNota').prop('disabled', false);
        $('#btnANota').prop('disabled', false);

        if (await retornaDatabase() == 'SQLSERVER') {
          tipoConcat = `CONCAT('C', NOTA.LANCAMENTO)`;
        } else {
          tipoConcat = `'C'||NOTA.LANCAMENTO`;
        }

        let pesquisa;

        if ($('#checkNotasEmpLogada').prop('checked') && $('#checkNotasConferidas').prop('checked')) {
          pesquisa = `"tabela": "NOTA",
                  "camposSelect": ["NOTA.FATURA", "NOTA.SERIE"],
                  "innerjoin": [{"tabela": "ENTIDADE", "condicao": "NOTA.CODCLI = ENTIDADE.CODCLI"}],
                  "where": ["NOTE.EMP_ID = ${empId} AND ENTIDADE.CNPJ = (SELECT EMP_CNPJ FROM [EMPRESA] WHERE EMP_ID = ${empId})", "NOT EXISTS (SELECT CODIGO FROM [PA_MOV] WHERE NUM_DOCTO = ${tipoConcat})", "NOT EXISTS (SELECT NF_CONF_ENTRA.NUMERO FROM [NF_CONF_ENTRA] NF_CONF_ENTRA WHERE NOTA.FATURA = NF_CONF_ENTRA.NUMERO AND NOTA.SERIE = NF_CONF_ENTRA.SERIE AND NOTA.EMP_ID = NF_CONF_ENTRA.EMP_ID_ORIGEM)"]`

          if (tabelasUnificadas) {
            $("#txtNota").autocompleta(1, `JSON={${pesquisa}}`);
            $('#btnNota').pesquisa_serverside(['#txtNota'], ['NOTA.FATURA'], ['NOTA.SERIE'], `{${pesquisa}}`, "Pesquisa Nota");
          } else {
            $("#txtNota").autocompleta(1, `JSON={${pesquisa}}`, undefined, undefined, undefined, undefined, undefined, empresa.replace('_', ''));
            $('#btnNota').pesquisa_serverside(['#txtNota'], ['NOTA.FATURA'], ['NOTA.SERIE'], `{${pesquisa}}`, "Pesquisa Nota", undefined, undefined, empresa);
          }
        } else if ($('#checkNotasEmpLogada').prop('checked')) {
          pesquisa = `"tabela": "NOTA",
                  "camposSelect": ["NOTA.FATURA", "NOTA.SERIE"],
                  "innerjoin": [{"tabela": "ENTIDADE", "condicao": "NOTA.CODCLI = ENTIDADE.CODCLI"}],
                  "where": ["NOTA.EMP_ID = ${empId}", "ENTIDADE.CNPJ = (SELECT EMP_CNPJ FROM [EMPRESA] WHERE EMP_ID = ${empId})", "NOT EXISTS (SELECT NF_CONF_ENTRA.NUMERO FROM [NF_CONF_ENTRA] NF_CONF_ENTRA WHERE NOTA.FATURA = NF_CONF_ENTRA.NUMERO AND NOTA.SERIE = NF_CONF_ENTRA.SERIE AND NOTA.EMP_ID = NF_CONF_ENTRA.EMP_ID_ORIGEM)"]`

          if (tabelasUnificadas) {
            $("#txtNota").autocompleta(1, `JSON={${pesquisa}}`);
            $('#btnNota').pesquisa_serverside(['#txtNota'], ['NOTA.FATURA'], ['NOTA.SERIE'], `{${pesquisa}}`, "Pesquisa Nota");
          } else {
            $("#txtNota").autocompleta(1, `JSON={${pesquisa}}`, undefined, undefined, undefined, undefined, undefined, empresa.replace('_', ''));
            $('#btnNota').pesquisa_serverside(['#txtNota'], ['NOTA.FATURA'], ['NOTA.SERIE'], `{${pesquisa}}`, "Pesquisa Nota", undefined, undefined, empresa);
          }
        } else if ($('#checkNotasConferidas').prop('checked')) {
          pesquisa = `"tabela": "NOTA",
                  "camposSelect": ["NOTA.FATURA", "NOTA.SERIE"],
                  "where": ["NOTA.EMP_ID = ${empId}", "NOT EXISTS (SELECT CODIGO FROM [PA_MOV] WHERE NUM_DOCTO = ${tipoConcat})", "NOT EXISTS (SELECT NF_CONF_ENTRA.NUMERO FROM [NF_CONF_ENTRA] NF_CONF_ENTRA WHERE NOTA.FATURA = NF_CONF_ENTRA.NUMERO AND NOTA.SERIE = NF_CONF_ENTRA.SERIE AND NOTA.EMP_ID = NF_CONF_ENTRA.EMP_ID_ORIGEM)"]`;

          if (tabelasUnificadas) {
            $("#txtNota").autocompleta(1, `JSON={${pesquisa}}`);
            $('#btnNota').pesquisa_serverside(['#txtNota'], ['NOTA.FATURA'], ['NOTA.SERIE'], `{${pesquisa}}`, "Pesquisa Nota");
          } else {
            $("#txtNota").autocompleta(1, `JSON={${pesquisa}}`, undefined, undefined, undefined, undefined, undefined, empresa.replace('_', ''));
            $('#btnNota').pesquisa_serverside(['#txtNota'], ['NOTA.FATURA'], ['NOTA.SERIE'], `{${pesquisa}}`, "Pesquisa Nota", undefined, undefined, empresa);
          }
        }
      }, 0);
    } catch (e) {
      console.log(e);
    } finally {
    }
  };

  async function alteraConsultaNotasEntrada() {
    try {
      const empresa = getCookie('empresa');
      const empId = await retornaEmpId(empresa);

      $('#txtNotaEntra').val('');
      $('#txtNotaEntra').unbind('autocompleta');
      $('#btnNotaEntra').unbind();
      // if ($('#checkNotasEntradaEmpLogada').prop('checked')) {
      //   $("#txtNotaEntra").autocompleta(1, `JSON={"tabela": "NOTA_ENTRA", "camposSelect": ["NOTAFISCAL CHAVE", "SERIE DESCRICAO"], "where": ["EMP_ID = ${empId}"]}`);
      //   $('#btnNotaEntra').pesquisa_serverside(['#txtNotaEntra'], ['NOTAFISCAL'], ['SERIE'], `{"tabela": "NOTA_ENTRA", "camposSelect": ["NOTAFISCAL", "SERIE"], "where": ["EMP_ID = ${empId}"]}`, "Pesquisa Nota Entrada");
      // } else 
      if (isChecked('#checkNotasEntradaConferidas')) {
        if (await retornaDatabase() == 'SQLSERVER') {
          tipoConcat = `CONCAT('C', NOTA_ENTRA.LANCAMENTO)`;
        } else {
          tipoConcat = `'C'||NOTA_ENTRA.LANCAMENTO`;
        }

        const tabela = isChecked('#radioProduto') ? 'PA_MOV' : 'MAT_MOV';

        $("#txtNotaEntra").autocompleta(3, `JSON={ "tabela":"NOTA_ENTRA", "camposSelect":["NOTA_ENTRA.NOTAFISCAL CHAVE, NOTA_ENTRA.SERIE DESCRICAO"], "leftJoin": [{"tabela": "${tabela}", "condicao": "${tabela}.NUM_DOCTO = ${tipoConcat}"}, {"tabela": "NF_CONF_ENTRA", "condicao": "NF_CONF_ENTRA.NUMERO = NOTA_ENTRA.NOTAFISCAL AND NF_CONF_ENTRA.SERIE = NOTA_ENTRA.SERIE AND NF_CONF_ENTRA.EMP_ID = NOTA_ENTRA.EMP_ID"}], "where": ["NOTA_ENTRA.TIPO = '55' AND ${tabela}.CODIGO IS NULL AND NF_CONF_ENTRA.NUMERO IS NULL"] }`, [], [], []);

        $('#btnNotaEntra').pesquisa_serverside(['#txtNotaEntra'], ['NOTA_ENTRA.NOTAFISCAL'], ['NOTA_ENTRA.SERIE'], `{"tabela": "NOTA_ENTRA",
                     "camposSelect": ["NOTA_ENTRA.NOTAFISCAL", "NOTA_ENTRA.SERIE"],
                     "leftJoin": [{"tabela": "${tabela}", "condicao": "${tabela}.NUM_DOCTO = ${tipoConcat}"}, {"tabela": "NF_CONF_ENTRA", "condicao": "NF_CONF_ENTRA.NUMERO = NOTA_ENTRA.NOTAFISCAL AND NF_CONF_ENTRA.SERIE = NOTA_ENTRA.SERIE AND NF_CONF_ENTRA.EMP_ID = NOTA_ENTRA.EMP_ID"}],
                     "where": ["NOTA_ENTRA.TIPO = '55' AND ${tabela}.CODIGO IS NULL AND NF_CONF_ENTRA.NUMERO IS NULL"]}`, "Pesquisa Nota Entrada");
        
      } else {
        $("#txtNotaEntra").autocompleta(1, `JSON={ "tabela":"NOTA_ENTRA", "camposSelect":["NOTAFISCAL CHAVE, SERIE DESCRICAO"], "where": ["1=1 AND NOT EXISTS (SELECT NF_CONF_ENTRA.NUMERO FROM [NF_CONF_ENTRA] NF_CONF_ENTRA WHERE NF_CONF_ENTRA.NUMERO = NOTA_ENTRA.NOTAFISCAL AND NF_CONF_ENTRA.SERIE = NOTA_ENTRA.SERIE AND NF_CONF_ENTRA.EMP_ID = NOTA_ENTRA.EMP_ID)"] }`, [], [], []);
        $("#btnNotaEntra").pesquisa_array(["#txtNotaEntra"], ["NOTAFISCAL"], ["SERIE"], `/sisplan/funcoes/v1/pesquisa?JSON={ "tabela":"NOTA_ENTRA", "camposSelect":[ "NOTAFISCAL", "SERIE" ], "where": ["1=1 AND NOT EXISTS (SELECT NF_CONF_ENTRA.NUMERO FROM [NF_CONF_ENTRA] NF_CONF_ENTRA WHERE NF_CONF_ENTRA.NUMERO = NOTA_ENTRA.NOTAFISCAL AND NF_CONF_ENTRA.SERIE = NOTA_ENTRA.SERIE AND NF_CONF_ENTRA.EMP_ID = NOTA_ENTRA.EMP_ID)"]}`, "Pesquisa Nota Entrada", "NOTA_ENTRA");
      }

      $('#btnLimpaNotaEntra').on('click', function () {
        $('#txtNotaEntra').val('')
      })

      // await componenteFiltro('notaEntra', true, true, '', ['1 = 1', 'NOT EXISTS (SELECT NF_CONF_ENTRA.NUMERO FROM [NF_CONF_ENTRA] NF_CONF_ENTRA WHERE NF_CONF_ENTRA.NUMERO = NOTA_ENTRA.NOTAFISCAL AND NF_CONF_ENTRA.SERIE = NOTA_ENTRA.SERIE AND NF_CONF_ENTRA.EMP_ID = NOTA_ENTRA.EMP_ID)']);

      await criaTabela()
    } catch (e) {
      console.log(e);
    } finally {
    }
  };

  async function criaTabela() {
    if (!(await VerificaReplicacao())) {
      const campos = $("#radioProduto").prop("checked") ? [5, 6, 7, 11, 12] : [3, 5, 6, 7, 11];
      $("#tabelaImportacao").DataTable({
        paging: false,
        filter: false,
        info: false,
        key: true,
        order: true,
        autoWidth: true,
        scrollY: "300px",
        destroy: true,
        columnDefs: [
          {
            targets: campos,
            visible: false,
          },
          {
            "render": function (data) {
              return parseFloat(data).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              })
            },
            "targets": [9],
            "className": 'pr-4 text-right'
          },
          {
            "targets": [10],
            "className": 'pr-4 text-right'
          }
        ],
      });
    } else {
      $("#tabelaImportacao").DataTable({
        paging: false,
        filter: false,
        info: false,
        order: true,
        key: true,
        autoWidth: true,
        scrollY: "300px",
        destroy: true,
        columnDefs: [
          {
            targets: [5, 6, 7, 8, 9, 10, 11, 12],
            visible: false,
          },
          {
            "render": function (data) {
              return parseFloat(data).toLocaleString("pt-BR", {
                maximumFractionDigits: 2,
                minimumFractionDigits: 2
              })
            },
            "targets": [9],
            "className": 'pr-4 text-right'
          },
          {
            "targets": [10],
            "className": 'pr-4 text-right'
          }
        ],
      });
    }
  }

  $('#txtQuantidadeBipada').val(0);

  $("#tabelaImportacao tbody").on("click", "tr", async function () {
    $("#tabelaImportacao tbody tr td")[0].click();
    $("#tabelaImportacao tbody tr.selected").removeClass("selected");
    $(this).addClass("selected");
  });

  try {
    const response = await carregaDadosDigitados();
    if (response.status === 200) {
      const jsonStr = await response.json();
      let desabilitaRFID = false;
      insereValor("#txtLancamento", jsonStr.lancamento);
      insereValor("#txtDocumento", jsonStr.documento);
      insereValor("#txtNota", jsonStr.nota);
      insereValor("#txtNumLeitura", jsonStr.numerorfid);
      bRFID = jsonStr.rfid;
      if (jsonStr.empresa != '') {
        $('#txtNota').prop('disabled', false);
        $('#btnNota').prop('disabled', false);
        $('#btnANota').prop('disabled', false);
      }
      insereValor("#txtEmpresa", jsonStr.empresa.split("] - ")[0].substr(1), jsonStr.empresa.split("] - ")[1]);
      insereValor("#txtDeposito", jsonStr.deposito.split("] - ")[0].substr(1), jsonStr.deposito.split("] - ")[1]);
      insereValor("#txtQualidade", jsonStr.qualidade.split("] - ")[0].substr(1), jsonStr.qualidade.split("] - ")[1]);
      insereValor("#txtDepositoSaida", jsonStr.depositoSaida.split("] - ")[0].substr(1), jsonStr.depositoSaida.split("] - ")[1]);
      insereValor("#txtTpMovimento", jsonStr.tpMovimento);
      jsonStr.itens.forEach((item, index) => {
        $("#tabelaImportacao")
          .DataTable()
          .row.add([
            item.codigo,
            item.descricao,
            item.cor,
            item.tam,
            item.qtde,
            item.barra,
            item.barra28,
            item.barracli,
            item.ativo,
            item.preco,
            item.qtdeConf,
            item.qualidade,
            ''
          ])
          .draw(false);

        if (item.qtde > item.qtdeConf) {
          $('#tabelaImportacao').children('tbody').children()[index].cells[7].style.color = 'red';
        } else {
          $('#tabelaImportacao').children('tbody').children()[index].cells[7].style.color = '#41f541';
        }

        if (item.qtdeConf > 0) {
          desabilitaRFID = true;
        }
      });
      listaBarrasBipadas = jsonStr.barrasbipadas;
      VerificaQuantidade();
      await HabilitaDesabilitaCampos();
      if (desabilitaRFID) {
        $("#btnRFID").addClass("d-none");
      }
      if (!(await VerificaReplicacao())) {
        $("#CampoConferencia").show();
        $("#CampoConferenciaQtde").show();
        $('#btnSom').removeClass('d-none');
      }
      msgAlerta("Carregado dados não salvos, verifique.");
    }
  } catch (error) { }

  $("#msform").validate({
    rules: {
      txtDocumento: {
        required: false,
      },
      txtLancamento: {
        required: false,
      },
      txtNota: {
        required: false,
      },
      txtEmpresa: {
        required: false,
      },
      txtQualidade: {
        required: true,
      },
      txtDeposito: {
        required: true,
      },
      txtConferencia: {
        required: false,
      },
    },
    messages: {
      txtDeposito: {
        required: "Informe um depósito válido.",
      },
      txtQualidade: {
        required: "Informe uma qualidade válida.",
      },
      txtNotaEntra: {
        required: "Informe uma nota válida.",
      },
      txtCredorNota: {
        required: "Informe um credor válido.",
      },
    },
    errorElement: "span",
    errorPlacement(error, element) {
      error.addClass("invalid-feedback");
      element.closest(".form-group").append(error);
    },
    highlight(element) {
      $(element).addClass("is-invalid");
    },
    unhighlight(element) {
      $(element).removeClass("is-invalid");
    },
  });

  async function VerificaReplicacao() {
    try {
      const url = `/sisplan/replicacao/v1/existereplicacao?`;

      const response = await requisicao("GET", url, "", null, 15000);

      if (!response) {
        return;
      }

      const jsonStr = await response.text();
      if (response.status != 200) {
        msgErro("Erro ao ");
        return;
      }

      if (jsonStr == "True") {
        return true;
      }
      return false;
    } catch (error) {
      console.error(error);
    }
  }

  $('#btnMenosOuMais').on('click', function () {
    const estaComoEstorno = $('#btnMenosOuMais>i.fa-minus').length > 0;
    $('#labelConferencia').html(estaComoEstorno ? 'Conferência' : 'Estorno');
    $('#txtConferencia').attr('placeholder', estaComoEstorno ? 'Informe as barras para conferência' : 'Informe as barras para estorno');
    $('#txtConferencia').focus();
    $('#btnMenosOuMais').attr('data-estorno', !estaComoEstorno);
    if (estaComoEstorno) {
      $('#btnMenosOuMais>i.fa-minus').removeClass('fa-minus').addClass('fa-plus');
    } else { $('#btnMenosOuMais>i.fa-plus').removeClass('fa-plus').addClass('fa-minus'); }
  });

  $('.somAtivo').on('click', function () {
    $(this).addClass('d-none');
    localStorage.setItem("@importacao.somAtivo", false);
    $('.somInativo').removeClass('d-none');
  });

  $('.somInativo').on('click', function () {
    $(this).addClass('d-none');
    localStorage.setItem("@importacao.somAtivo", true);
    $('.somAtivo').removeClass('d-none');
  });

  const somAtivo = localStorage.getItem('@importacao.somAtivo') ?? 'false';
  if (somAtivo == 'true') {
    $($('.somInativo')[0]).trigger('click');
  }

  $("#btnImprimir").click(async function () {
    ImprimirRelatorio();
  });

  $("#btnCancelar").click(async function () {
    msgAlerta(
      `Tem certeza que deseja cancelar? Todos os dados em tela serão perdidos`,
      async function () {
        await deletaDadosDigitados();
        window.location.reload();
        window.location.href = `${BASE_URI}/importacao`;
      }
    );
  });

  $("#btnImportar").click(async function () {
    $("#btnImportar").prop('disabled', true);
    $.LoadingOverlay("show");
    try {
      if (
        $("#radioTransf").prop("checked") &&
        $("#txtDepositoSaida").val() == ""
      ) {
        msgErro("Depósito de saída não informado, impossível continuar");
        return;
      }
      if ($("#tabelaImportacao").DataTable().column(10, {}).data().sum() == 0) {
        await msgAguardaConfirmacao('Nenhuma quantidade conferida, será considerada a quantidade de itens da movimentação. Deseja continuar?', async function () {
          await senhaSupervisor('',
            setaQuantidadeConf,
            '',
            false,
            () => { $("#btnImportar").prop('disabled', false) },
            undefined,
            undefined,
            false,
            'IMPORTACAO');
        },
          () => { $("#btnImportar").prop('disabled', false) });
      } else {
        await chamaImportacao();
        $("#btnImportar").prop('disabled', false);
      }
    } catch (error) {
      $("#btnImportar").prop('disabled', false);
      deletaDadosDigitados();
      window.location.href = `${BASE_URI}/importacao`;
    } finally {
      $.LoadingOverlay("hide");
    }
  });

  async function chamaImportacao() {
    const Conferida = await VerificaQuantidadeConferida();
    if (!(await VerificaReplicacao())) {
      if (Object.entries(Conferida).length > 0 && $('#radioProduto').is(':checked')) {
        await senhaSupervisor(
          `Quantidade Conferida diferente do campo quantidade, será dada entrada no estoque com o campo Quantidade Conferida.`,
          () => {
            RealizaImportacao()
          },
          '',
          false,
          () => { $("#btnImportar").prop('disabled', false) }, undefined, undefined, false, 'IMPORTACAO'
        );
      } else if (Object.entries(Conferida).length > 0 && $('#radioMaterial').is(':checked')) {
        msgAlerta(`Quantidade Conferida diferente do campo quantidade, será dada entrada no estoque com o campo Quantidade Conferida.`,
          () => {
            RealizaImportacao();
          });
      } else {
        await RealizaImportacao();
      }
    } else {
      await RealizaImportacao();
    }
  }

  async function setaQuantidadeConf() {
    $("#tabelaImportacao").DataTable().rows().data().map((item, index) => {
      item[10] = item[4];
      $("#tabelaImportacao").DataTable().row(index).data(item).draw(false);
    });
    rotinaGeraLog('IMPORTACAO', pegaChave('#txtDocumento'), `Importado documento digitando senha de supervisor (sem conferir itens)`, 'Movimentação');
    if (confirmaNaoEhTIpoEntradaLoja) {
      let chave = pegaChave('#txtTpMovimento')
      rotinaGeraLog('IMPORTACAO', chave, `Movimentação feita com tipo de baixa não configurada com a opção SAÍDA LOJA, Usuario: ${getCookie('cod_usuario')}-${getCookie('usuario')}, Empresa: ${getCookie('emp_id')} `, 'Movimentação');
    }
    await chamaImportacao();
  };

  async function retornaArrayTransferencia(data) {
    try {

      let arrayTransferencia = [];
      if ($("#radioProduto").prop("checked")) {
        data.each((campo) => {
          obj = {
            CODIGO: campo[0],
            DESCRICAO: campo[1],
            COR: campo[2].split(' - ')[0],
            TAMANHO: campo[3],
            QTDE: campo[4],
            BARRA: campo[5],
            BARRA28: campo[6],
            BARRACLI: campo[7],
            ATIVO: campo[8],
            PRECO: campo[9],
            QTDECONFERIDA: campo[10],
            QUALIDADE: campo[11],
          };
          arrayTransferencia.push(obj);
        });
      } else {


        const { document } = await retornaDocumentoGravarMaterial()
        data.each((campo) => {
          if (campo[10] > 0) {
            obj = {
              CODIGO: campo[0],
              COR: campo[2].split(' - ')[0],
              DEPOSITO: campo[13],
              QTDE: campo[4],
              NUM_DOCTO: document,
              DOCTO: campo[17],
              QUALIDADE: campo[11],
              LOTE: campo[12] === '000000' ? $(campo[12]).find('span').text().trim() : campo[12],
              TIPO: pegaChave('#txtTpMovimento'),
              TP_MOV: 'MN',
              TONALIDADE: campo[14],
              LOTE_INTERNO: campo[15],
              DT_FAB: !!campo[16] ? campo[16].replace(' ', 'T') + 'Z' : campo[16],
              CODBAIXA: pegaChave('#txtTpMovimento'),
              PRECO: campo[9]
            };
            arrayTransferencia.push(obj);
          }
        });
      }

      return arrayTransferencia;

    } catch (error) {
      console.error(error);
    }
  }

  async function retornaDocumentoGravarMaterial() {
    try {
      let document = pegaChave('#txtDocumento')
      if (document) {
        return {
          document,
        }
      }
      document = $('#txtLancamento').val()
      if (document) {
        return {
          document: 'C' + document,
        }
      }

      const selectedOption = $('input[name="tipoConf"]').filter(':checked').val()
      switch (selectedOption) {
        case 'normal':
          {
            const nota = pegaChave('#txtNota')
            const serie = pegaDescricao('#txtNota')
            if (nota && serie) {
              document = await buscaValor('NOTA', 'LANCAMENTO', 'FATURA', `${nota}' AND SERIE = '${serie}`)
            }

            return {
              document: 'C' + document?.LANCAMENTO || '',
            }
          }
        case 'transferencia':
          return {
            document: 'C' + document,
          }
        case 'entrada':
          {
            const nota = pegaChave("#txtNotaEntra")
            const serie = pegaDescricao("#txtNotaEntra")
            // const nota = $("#txtNotaEntra").val().toString().split(',')[0].replaceAll("'", '')
            // const serie = '1'
            const credor = pegaChave('#txtCredorNota')
            if (nota && serie && credor) {
              document = await buscaValor('NOTA_ENTRA', 'LANCAMENTO', 'NOTAFISCAL', `${nota}' AND SERIE = '${serie}' AND TIPO = '55' AND CREDOR = '${credor}`)
            }
            return {
              document: 'C' + document?.LANCAMENTO || '',
            }
          }
        default:
          return {
            document: 'C' + document,
          }
      }
    } catch (e) {
      return {
        document: '',
      }
    }
  }

  async function ValidaEstoque(data) {
    try {
      if ($('#radioNormal').prop('checked') == true || isChecked('#radioNotaEntra')) {
        return true;
      }
      const arrayTransferencia = await retornaArrayTransferencia(data);
      const despositoSaida = pegaChave('#txtDepositoSaida');
      const bProduto = $("#radioProduto").prop("checked");
      const campo = bProduto ? 'QTDECONFERIDA' : 'QTDE';
      const url = '/sisplan/estoque/v1/validaestoque?';
      for (let i = 0; i < arrayTransferencia.length; i++) {
        const params = `CODIGO=${arrayTransferencia[i].CODIGO}&COR=${arrayTransferencia[i].COR}&LOTE=${bProduto ? '000000' : arrayTransferencia[i].LOTE}` +
          `&TAM=${arrayTransferencia[i].TAMANHO}&DEPOSITO=${despositoSaida}&QUALIDADE=${arrayTransferencia[i].QUALIDADE}&TIPO=${bProduto ? 'P' : 'M'}` +
          `&QUANTIDADE=${arrayTransferencia[i][campo]}&LANCAMENTO=-99`;
        const response = await requisicao('GET', url, params, false, 30000);

        if (!response) {
          return false;
        }

        if (response.status != 200) {
          const jsonStr = await response.json();
          msgErro(jsonStr.mensagem);
          return false;
        }
      }

      return true;

    } catch (error) {
      console.error(error);
    }
  }

  async function RealizaImportacao() {
    let lancamento = $("#txtLancamento").val();
    let documento = pegaChave("#txtDocumento");
    let nf = pegaChave("#txtNota") != '' ? pegaChave('#txtNota') : pegaChave("#txtNotaEntra")
    let serie = pegaDescricao("#txtNota") != '' ? pegaDescricao('#txtNota') : pegaDescricao("#txtNotaEntra")
    // let nf = pegaChave("#txtNota") != '' ? pegaChave('#txtNota') : await formataListas($("#txtNotaEntra").val().toString());
    let empnf = pegaChave("#txtEmpresa");
    let deposito = pegaChave("#txtDeposito");
    let qualidade = pegaChave("#txtQualidade");
    let data = $("#tabelaImportacao").DataTable().rows().data();
    let url;
    let params;
    let response;
    let jsonStr;
    let arrayTransferencia = [];
    let obj = {};
    let depositoFiltro = pegaChave("#txtDeposito");
    let qualidadeFiltro = pegaChave("#txtQualidade");
    const tpMovimento = pegaChave("#txtTpMovimento");

    if (lancamento == "" && documento == "" && nf == "") {
      throw msgAlerta("Os campos lançamento, documento e nota estão vazios, um deles deve ser informado para prosseguir com a importação.");
    }

    const barraslog = {
      barras: utilizaBarraLog ? listaBarrasBipadas : []
    };

    const depositoSaida = $("#radioTransf").prop("checked")
      ? pegaChave("#txtDepositoSaida")
      : "";

    try {
      if (await ValidaEstoque(data)) {
        if (!(await VerificaReplicacao())) {
          if ($("#radioProduto").prop("checked")) {
            const tabela = isChecked('#radioNotaEntra') ? 'NOTA_ENTRA' : '';
            arrayTransferencia = await retornaArrayTransferencia(data);
            urlTransferencia = `/sisplan/estoque/v1/transferenciaentrefiliais?`;
            paramsTransferencia = `DEPOSITO=${depositoFiltro}` +
              `&QUALIDADE=${qualidadeFiltro}` +
              `&DOCUMENTO=${documento}` +
              `&LANCAMENTO=${lancamento}` +
              `&NOTA=${nf}` +
              `&SERIE=${serie}` +
              `&CREDOR=${pegaChave('#txtCredorNota')}` +
              `&DEPOSITOSAIDA=${depositoSaida}` +
              `&TPMOVIMENTO=${tpMovimento}` +
              `&RFID=${bRFID ? 'S' : 'N'}` +
              `&NUMERORFID=${$('#txtNumLeitura').val()}` +
              `&TABELA=${tabela}`;
            objetoTransferencia = {
              produtos: arrayTransferencia,
              barras: barraslog.barras
            };
          } else {
            const tabela = isChecked('#radioNotaEntra') ? 'NOTA_ENTRA' : '';
            const lancamento = await RetornaDoctoELancto('LANCTO', 'MAT_MOV', 'NUM_DOCTO', '6');
            arrayTransferencia = await retornaArrayTransferencia(data);
            urlTransferencia = `/sisplan/estoque/v1/transferenciaestoquematerial?`;
            const tipoConferencia = isChecked('#radioNotaEntra') ? 'Nota Entrada' : isChecked('#radioTransf') ? 'Transferência' : isChecked('#radioNormal') ? 'Normal' : '';
            const novoItem = {
              codigo: '',
              cor: '',
              lote: '',
              qualidade: '',
              quantidade: 0,
            }
            paramsTransferencia = `DEPOSITO_DESTINO=${deposito}` +
              `&LANCAMENTO=${lancamento}` +
              `&CREDOR=${pegaChave('#txtCredorNota')}` +
              `&SERIE=${serie}` +
              `&NOTA=${nf}` +
              `&UPDATE_MAT_ITEN=${true}` +
              `&TABELA=${tabela}` +
              `&TIPO_CONFERENCIA=${tipoConferencia}` +
              `&NOVO_ITEM=${encodeURIComponent(JSON.stringify(novoItem))}`;
            objetoTransferencia = {
              materiais: arrayTransferencia
            };
          }
          documentoGlobal = documento;
          let bDesejaContinuar = await VerificaQuantidadeBipada(arrayTransferencia);
          if (!bDesejaContinuar) {
            msgAlerta(
              "A quantidades sem conferência, Deseja Continuar?",
              await transferenciaEntreFiliais()
            );
          } else {
            await transferenciaEntreFiliais();
          }
        } else {
          url = `/sisplan/Replicacao/v1/solicitamov?`;
          const filtros = await retornaFiltros();
          params = `TIPO=P&${filtros}&IMPORTADO=1`;
          response = await requisicao("GET", url, params, null);
        }

        if (!response) {
          $("#btnImportar").prop('disabled', false);
          deletaDadosDigitados();
          // window.location.href = `${BASE_URI}/importacao`; //comentado pq tava recarregando a tela e não mostrava a mensagem de estoque inválido.
          return;
        }

        if (await VerificaReplicacao()) {
          jsonStr = await response.json();
        }
        if (response.status != 200) {
          msgErro(jsonStr.mensagem, () => { deletaDadosDigitados(); window.location.href = `${BASE_URI}/importacao`; });
          $("#btnImportar").prop('disabled', false);
          return "";
        }
        $.LoadingOverlay("hide");

        if (confirmaNaoEhTIpoSaidaLoja) {
          let chave = pegaChave('#txtTpMovimento')
          rotinaGeraLog('IMPORTACAO', chave, `Movimentação feita com tipo de baixa não configurada com a opção SAÍDA LOJA, Usuario: ${getCookie('cod_usuario')}-${getCookie('usuario')}, Empresa: ${getCookie('emp_id')} `, 'Movimentação');
        }

        criaMensagemSucesso(`Importação efetuada com sucesso! ${documento ? `Documento: ${docummento}` : ''}`, () => { deletaDadosDigitados(); window.location.href = `${BASE_URI}/importacao`; $("#btnImportar").prop('disabled', false); });
      }
    } catch (error) {
      console.error(error);
      $("#btnImportar").prop('disabled', false);
      deletaDadosDigitados();
      window.location.href = `${BASE_URI}/importacao`;
    }
  }

  async function retornaFiltros() {
    const lancamento = $("#txtLancamento").val();
    const documento = pegaChave("#txtDocumento");
    const nf = isChecked('#radioNotaEntra') ? pegaChave("#txtNotaEntra") : pegaChave("#txtNota");
    // const nf = isChecked('#radioNotaEntra') ? await formataListas($("#txtNotaEntra").val().toString()) : pegaChave("#txtNota");
    const empnf = pegaChave("#txtEmpresa");
    const tipo = $("#radioProduto").prop("checked") ? 'P' : 'M';
    const deposito = pegaChave("#txtDeposito");
    const depositoSaida = pegaChave("#txtDepositoSaida");
    const qualidade = pegaChave("#txtQualidade");
    const tabela = isChecked('#radioNotaEntra') ? 'NOTA_ENTRA' : '';
    const serie = isChecked('#radioNotaEntra') ? pegaDescricao("#txtNotaEntra") : pegaDescricao("#txtNota");
    const credor = pegaChave('#txtCredorNota');
    const retorno =
      `NOTA=${nf}` +
      `&EMPNOTA=${empnf}` +
      `&DOCUMENTO=${documento}` +
      `&DEPOSITO=${deposito}` +
      `&QUALIDADE=${qualidade}` +
      `&LANCAMENTO=${lancamento}` +
      `&AGRUPALANCAMENTO=N` +
      `&TIPO=${tipo}` +
      `&TABELA=${tabela}` +
      `&SERIE=${serie}` +
      `&CREDOR=${credor}`;
    return retorno;
  }

  async function validaTipoConferencia() {
    try {
      if (!$("#radioTransf").prop("checked")) {
        return true;
      }
      const tabela = $("#radioProduto").is(":checked") ? 'PA_MOV' : 'MAT_MOV';
      const numDocto = pegaChave("#txtDocumento");
      const numLancto = $("#txtLancamento").val();

      if (numDocto === "" && numLancto === "") {
        msgErro(
          "Necessário informar um número de documento ou lançamento para continuar."
        );
        return false;
      }

      const where =
        `1=1${numDocto !== "" ? ` and NUM_DOCTO='${numDocto}'` : ""}` +
        `${numLancto !== "" ? ` and LANCAMENTO=${numLancto}` : ""
        } and OPERACAO='E'`;

      const dadosSelect = {
        tabela: tabela,
        camposSelect: [`${tabela}.DEPOSITO`, `DEPOSITO.DESCRICAO`],
        leftJoin: [
          {
            tabela: "DEPOSITO",
            condicao: `DEPOSITO.CODIGO = ${tabela}.DEPOSITO`,
          },
        ],
        where: [`${where}`],
      };
      const retornoSelect = await retornaJsonPesquisaPadrao(
        JSON.stringify(dadosSelect)
      );
      insereValor(
        "#txtDepositoSaida",
        retornoSelect[0].DEPOSITO,
        retornoSelect[0].DESCRICAO
      );
      return true;
    } catch (error) {
      console.error(error);
      return false;
    }
  }

  $("#btnConsultar").click(async function () {
    $("#btnConsultar").prop('disabled', true);
    try {
      if ($("#msform").validate().form()) {
        const filtros = await retornaFiltros();
        let params = tabelasUnificadas ? `IMPORTADO=0&${filtros}` : `IMPORTADO=0&${filtros}&EMPRESA=${empPesquisa}`;
        let url = "";
        if (!(await validaTipoConferencia())) {
          msgErro("Para esse tipo de conferência, deve ser utilizado um documento/lançamento de transferência (Saída/Entrada de Estoque).");
          return;
        }

        if ($("#txtLancamento").val() == "" && $("#txtDocumento").val() == "" && $("#txtNota").val() == "" && $("#txtNotaEntra").val() == "") {
          throw msgAlerta("Os campos lançamento, documento e nota estão vazios, um deles deve ser informado para prosseguir com a importação.");
        }

        try {
          $.LoadingOverlay("show");
          if (!(await VerificaReplicacao())) {
            url = `/sisplan/estoque/v1/buscapamov?`;
            $('#btnSom').removeClass('d-none');
            $("#CampoConferencia").show();
            $("#CampoConferenciaQtde").show();
          } else {
            url = `/sisplan/Replicacao/v1/solicitamov?`;
          }
          let response = await requisicao("GET", url, params, null, 300000);

          if (!response) {
            return "";
          }

          let jsonStr = await response.json();
          if (response.status != 200) {
            msgErro(jsonStr.mensagem);
            $.LoadingOverlay("hide");
            return;
          }

          if (!(await VerificaReplicacao())) {
            await preencheTabelaPaMov(jsonStr);
          } else {
            await retornaMovimentacao(jsonStr.CODIGO);
          }
        } catch (error) {
          $.LoadingOverlay("hide");
          console.error(error);
        }
      }
    } catch (error) {
      console.log(error);
    } finally {
      $("#btnConsultar").prop('disabled', false);
    }
  });

  let contador = 0;
  let nrmovimentacao = 0;

  async function retornaMovimentacao(nrMov) {
    _url = `/sisplan/replicacao/v1/visualizamov?`;
    _params = `NRCONTROLE=${nrMov}`;

    try {
      response = await requisicao("GET", _url, _params, null);

      if (!response) {
        return "";
      }

      jsonStr = await response.json();
      if (response.status != 200) {
        msgErro(jsonStr.mensagem);
        return "";
      }
      if (jsonStr.length > 0) {
        await preencheTabela(jsonStr[0].FDBS.Manager.TableList[0].RowList);
      } else if (contador < 100) {
        if (contador == 0) {
          nrmovimentacao = nrMov;
        }
        await setTimeout(async function () {
          await retornaMovimentacao(nrmovimentacao);
        }, 3000);
        contador += 1;
      } else {
        msgAlerta("Arquivo não encontrado.");
        $("#btnImportar").addClass("d-none");
        $("#btnRFID").addClass("d-none");
        $("#btnImprimir").addClass("d-none");
        $("#btnCancelar").removeClass("d-none");
        $("#btnConsultar").removeClass("d-none");
        $('#btn-documento').attr('disabled', false);
        $('#btn-limpa-documento').attr('disabled', false);
        $("#txtLancamento").attr("disabled", false);
        $("#txtDocumento").attr("disabled", false);
        $("#txtNota").attr("disabled", false);
        $("#btnNota").attr("disabled", false);
        $("#btnANota").attr("disabled", false);
        $("#txtEmpresa").attr("disabled", false);
        $("#btnEmpresa").attr("disabled", false);
        $("#btnAEmpresa").attr("disabled", false);
        $("#txtDeposito").attr("disabled", false);
        $("#btnDeposito").attr("disabled", false);
        $("#txtQualidade").attr("disabled", false);
        $("#btnQualidade").attr("disabled", false);
        $("#txtLancamento").attr("disabled", false);
        $("#txtLancamento").attr("disabled", false);
        $("#btnLimpaDeposito").attr("disabled", false);
        $("#btnLimpaQualidade").attr("disabled", false);
        $.LoadingOverlay("hide");
        contador = 0;
        return;
      }
    } catch (error) {
      $.LoadingOverlay("hide");
      console.error(error);
    }
  }

  async function preencheTabela(data) {
    data.forEach((element) => {
      // eslint-disable-next-line no-param-reassign
      element = element.Original;
      $("#tabelaImportacao")
        .DataTable()
        .row.add([
          element.CODIGO,
          element.DESCRICAO,
          element.COR,
          element.TAMANHO,
          element.QTDE,
          "",
          "",
          "",
          "",
          "",
          "",
          "",
          ""
        ])
        .draw(false);
    });
    await HabilitaDesabilitaCampos();
  }

  async function preencheTabelaPaMov(data) {
    if ($("#radioProduto").prop("checked")) {
      data.forEach((element, index) => {
        $("#tabelaImportacao")
          .DataTable()
          .row.add([
            element.CODIGO,
            element.DESCRICAO,
            element.COR + ' - ' + element.DESC_COR,
            element.TAM,
            element.QTDE,
            element.BARRA,
            element.BARRA28,
            element.BARRACLI,
            element.ATIVO,
            element.PRECO,
            element.QTDECONFERIDA,
            element.QUALIDADE,
            pegaChave('#txtDepositoSaida'),
            pegaChave('#txtDeposito'),
            element.NUMERO
          ])
          .draw(false);
        if (element.QTDE > element.QTDECONFERIDA) {
          $('#tabelaImportacao').children('tbody').children()[index].cells[7].style.color = 'red';
        } else {
          $('#tabelaImportacao').children('tbody').children()[index].cells[7].style.color = '#41f541';
        }
      });
    } else {
      data.forEach((element, index) => {
        let colunaLote = element.LOTE;
        if (element.LOTE === '000000') {
          colunaLote = `
            <div style="display: flex; align-items: center;">
              <span class="ml-4 pl-4">${element.LOTE}</span>
              <i class="fas fa-check adicionaQtdePesquisaMaterial acaoIcon ml-2 mb-1" 
                 id="adicionaQtdePesquisaMaterial${index}" 
                 style="font-size: 18px; margin-right: 5px; cursor: pointer;" 
                 title="Conferir Quantidade"></i>
            </div>`;
        }
        if (!element.QTDECONFERIDA) {
          element.QTDECONFERIDA = 0
        }

        let row = [
          element.CODIGO,
          element.DESCRICAO,
          element.COR + ' - ' + element.DESC_COR,
          element.TAM,
          element.QTDE,
          element.BARRA,
          element.BARRA28,
          element.BARRACLI,
          element.ATIVO,
          element.PRECO,
          element.QTDECONFERIDA,
          element.QUALIDADE,
          colunaLote,
          element.DEPOSITO,
          element.TONALIDADE,
          element.LOTE_INTERNO,
          element.DT_FAB,
          element.NUMERO
        ];

        $("#tabelaImportacao").DataTable().row.add(row).draw(false);
        if (element.LOTE === '000000') {
          $(`#adicionaQtdePesquisaMaterial${index}`).on('click', function () {
            if ($(this).hasClass('fa-check-circle')) {
              element.QTDECONFERIDA -= element.QTDE
            } else {
              element.QTDECONFERIDA += element.QTDE;
            }
            $('#tabelaImportacao').DataTable().cell(index, 10).data(element.QTDECONFERIDA).draw(false);


            if (element.QTDE > element.QTDECONFERIDA) {
              $('#tabelaImportacao').children('tbody').children()[index].cells[6].style.color = 'red';
              $(this).removeClass('fa-check-circle').addClass('fa-check').css('color', 'white');
            } else {
              $('#tabelaImportacao').children('tbody').children()[index].cells[6].style.color = '#41f541';
              $(this).removeClass('fa-check').addClass('fa-check-circle').css('color', 'green');
            }
          });
        }

        if (element.QTDE > element.QTDECONFERIDA) {
          $('#tabelaImportacao').children('tbody').children()[index].cells[6].style.color = 'red';
        } else {
          $('#tabelaImportacao').children('tbody').children()[index].cells[6].style.color = '#41f541';
        }

      });
    }
    await HabilitaDesabilitaCampos();
  }

  async function HabilitaDesabilitaCampos() {
    $("#btnImportar").removeClass("d-none");
    if (bUsaIntegraçãoITAG) {
      $("#btnRFID").removeClass("d-none");
    }
    $("#btnImprimir").removeClass("d-none");
    $("#btnCancelar").removeClass("d-none");
    $("#btnConsultar").addClass("d-none");
    $("#btn-documento").attr("disabled", "disabled");
    $("#btn-limpa-documento").attr("disabled", "disabled");
    $("#txtLancamento").attr("disabled", "disabled");
    $("#txtDocumento").attr("disabled", "disabled");
    $("#txtNota").attr("disabled", "disabled");
    $("#btnNota").attr("disabled", "disabled");
    $("#btnANota").attr("disabled", "disabled");
    $("#txtEmpresa").attr("disabled", "disabled");
    $("#btnEmpresa").attr("disabled", "disabled");
    $("#btnAEmpresa").attr("disabled", "disabled");
    $("#txtDeposito").attr("disabled", "disabled");
    $("#btnDeposito").attr("disabled", "disabled");
    $("#txtQualidade").attr("disabled", "disabled");
    $("#btnQualidade").attr("disabled", "disabled");
    $("#txtLancamento").attr("disabled", "disabled");
    $("#txtLancamento").attr("disabled", "disabled");
    $("#btnLimpaDeposito").attr("disabled", "disabled");
    $("#btnLimpaQualidade").attr("disabled", "disabled");
    $("#radioProduto").attr("disabled", "disabled");
    $("#radioMaterial").attr("disabled", "disabled");
    if (!$("#radioProduto").prop("checked")) {
      $("#CampoConferenciaQtde").attr("hidden", true);
    } else {
      $("#CampoConferenciaQtde").attr("hidden", false);
    }
    $.LoadingOverlay("hide");
  }

  async function adicionaBarraBipada(objItem) {
    try {
      const retornoBarraLog = await retornaBarraLogLida(objItem.barra);
      if (['barra_log'].includes(retornoBarraLog)) {
        listaBarrasBipadas.push(objItem);
      }
    } catch (error) {
      console.error(error);
    }
  }

  async function retornaBarraLogLida(sBarra) {
    try {
      const url = `/sisplan/barralog/v1/validarbarra?`;
      const params = `barra=${encodeURIComponent(sBarra)}`;
      const response = await requisicao('GET', url, params, 15000);

      if (!response) {
        return;
      }

      jsonStr = await response.json();
      if (response.status != 200) {
        return jsonStr.mensagem;
      }

      return jsonStr.mensagem;
    } catch (error) {
      console.error(error);
    }
  }

  async function barraJaEstaBipada(sBarra, estornaQuantidade) {
    try {
      if (listaBarrasBipadas.find(item => item.barra == sBarra)) {
        if (!estornaQuantidade) {
          msgErro(`Barra ${sBarra} já lida, verifique.`);
        }
        return true;
      }
      return false;
    } catch (error) {
      console.error('barra_log', error);
      msgErro('Erro ao processar barra log.');
      return false;
    }
  }

  async function removeItemListaBarra(sCodigo, sCor, sTam) {
    try {
      listaBarrasBipadas = [...listaBarrasBipadas.filter(item => item.codigo !== sCodigo && item.cor !== sCor && item.tam !== sTam)];
    } catch (error) {
      console.error(error);
    }
  }

  async function estornaBarraBipada(sBarra) {
    try {
      listaBarrasBipadas = [...listaBarrasBipadas.filter(item => item.barra !== sBarra)];
    } catch (error) {
      console.error(error);
    }
  }

  async function VerificaQuantidade() {
    const quantidade = $("#tabelaImportacao")
      .DataTable()
      .column(10, {})
      .data()
      .sum();
    $('#txtQuantidadeBipada').val(+quantidade);
  }

  async function BarraEncontrada(barraBipada) {
    const estornaQuantidade = $('#btnMenosOuMais').attr('data-estorno');

    if (barraBipada != "") {
      const dados = $("#tabelaImportacao").DataTable().rows().data().toArray();
      const ebarralog = await retornaBarraLogLida(barraBipada) == "barra_log";

      if (!ebarralog && bApenasBarraLog) {
        msgAlerta('Barra log não encontrada, impossível continuar!');
        return;
      }

      let sBarraBipada = barraBipada;
      if (ebarralog) {
        sBarraBipada = await extraiBarra28(sBarraBipada);
      }
      let qtde = ebarralog ? 1 : (pegaValor('#txtQuantidade') > 0 ? parseFloat(pegaValor('#txtQuantidade')) : 1);
      let indiceEncontrado;
      if ($("#radioProduto").prop("checked")) {
        indiceEncontrado = dados.findIndex(
          (item) =>
            (item[5] == sBarraBipada ||
              item[6] == sBarraBipada ||
              item[7] == sBarraBipada ||
              (item[6] == sBarraBipada.substr(0, 6) && ebarralog)) && ((estornaQuantidade == 'true') || (item[10] < item[4]))
        );
      } else {
        indiceEncontrado = dados.findIndex(
          (item) =>
            item[5] == sBarraBipada ||
            item[12] == sBarraBipada
        );
      }

      if (indiceEncontrado !== -1) {
        if ((!$("#radioProduto").prop("checked")) && (!estornaQuantidade)) {
          msgAlerta('Barra já lida, impossível continuar.');
          return;
        }
        const dadosItem = $("#tabelaImportacao")
          .DataTable()
          .row(indiceEncontrado)
          .data();

        if (!$("#radioProduto").prop("checked")) {
          qtde = dadosItem[4];
        }
        const barraBipada = false;

        if (utilizaBarraLog) {
          if ((!(estornaQuantidade == 'true')) && (await barraJaEstaBipada($('#txtConferencia').val(), estornaQuantidade == 'true'))) {
            return;
          }

          await adicionaBarraBipada(
            {
              codigo: dadosItem[0],
              cor: dadosItem[2],
              tam: dadosItem[3],
              barra: $('#txtConferencia').val(),
            }
          );
        }

        if (((dadosItem[10] + qtde) <= dadosItem[4]) && estornaQuantidade == 'false') {
          $('#txtQuantidade').val('1');
          dadosItem[10] += qtde;
          SomAlerta(BASE_URI, false);
        } else if (((dadosItem[10] - qtde) >= 0) && estornaQuantidade == 'true') {
          $('#txtQuantidade').val('1');
          dadosItem[10] -= qtde;
          estornaBarraBipada($('#txtConferencia').val());
          SomAlerta(BASE_URI, false);
        } else if (dadosItem[10] == 0 && estornaQuantidade == 'true') {
          $('#txtQuantidade').val('1');
          msgAlerta(`Item ${dadosItem[0]} sem quantidade para estornar, verifique!`);
          estornaBarraBipada($('#txtConferencia').val());
          SomAlerta(BASE_URI, true);
        } else {
          $('#txtQuantidade').val('1');
          SomAlerta(BASE_URI, true);
          msgAlerta(
            `Quantidade total do item: ${dadosItem[0]} já conferida`,
            null,
            null,
            () => {
              $("#txtConferencia").focus();
              if (bRFID) {
                bRFIDAbort = true;
                zeraQtdeConf();
              }
            }
          );
          $("#txtConferencia").val("");
        }

        if (!barraBipada) {
          $('#txtQuantidade').val('1');
          $("#tabelaImportacao")
            .DataTable()
            .row(indiceEncontrado)
            .data(dadosItem)
            .draw(false);
          $($("#tabelaImportacao tbody tr")[indiceEncontrado]).click();
          $(".dataTables_scrollBody").scrollTo(
            $("#tabelaImportacao tbody tr").eq(indiceEncontrado),
            200
          );
          await salvaDadosDigitados();
        }

        $("#txtConferencia").val("");
        $("#txtConferencia").focus();
        await VerificaQuantidade();

        let cellIndex
        if ($("#radioProduto").prop("checked")) {
          cellIndex = 7
        } else {
          cellIndex = 6
        }
        if (dadosItem[4] > dadosItem[10]) {
          $('.selected')[0].cells[cellIndex].style.color = 'red';
        } else {
          $('.selected')[0].cells[cellIndex].style.color = '#41f541';
        }

      } else {
        $('#txtQuantidade').val('1');
        SomAlerta(BASE_URI, true);
        if (!bRFID) {
          msgAlerta("Nenhuma barra localizada", null, null, () => {
            $("#txtConferencia").focus();
          });
        } else {
          bRFIDAbort = true;
          if ($("#txtConferencia").val() != '') {
            barraNaoEncontrada.push($("#txtConferencia").val());
          }
          $("#txtConferencia").focus();
          $("#txtConferencia").val("");
          return false;
        }
        $("#txtConferencia").val("");
      }

    }
  }

  async function LocalizaBarraGridPesquisa() {
    const barraBipada = pegaChave("#txtConferencia");
    await BarraEncontrada(barraBipada);
  }

  async function LocalizaBarraGrid() {
    const barraBipada = $("#txtConferencia").val();
    await BarraEncontrada(barraBipada);
  }

  $("#txtConferencia").on("blur", async function () {
    await LocalizaBarraGrid();
  });

  $("#txtConferencia").on("keydown", async function (event) {
    if (event.key == "Enter") {
      $("#txtConferencia").trigger("blur");
    }
  });

  async function VerificaQuantidadeBipada(arrayTransferencia) {
    let bPassou = true;
    arrayTransferencia.forEach((item) => {
      if (item.QTDECONFERIDA == 0) {
        bPassou = false;

      }
    });
    return bPassou;
  }

  async function transferenciaEntreFiliais() {
    try {
      response = await requisicao(
        "POST",
        urlTransferencia,
        paramsTransferencia,
        JSON.stringify(objetoTransferencia),
        300000
      );
      if (!response) {
        return;
      }

      if (response.status != 200) {
        let jsonStr = await response.json();
        return msgAlerta(jsonStr.mensagem,
          undefined,
          undefined,
          () => { window.location.href = `${BASE_URI}/importacao`; },
          () => { window.location.href = `${BASE_URI}/importacao`; },
        );
      }
      await ImprimirRelatorio();

      criaMensagemSucesso(`Importação efetuada com sucesso! ${documentoGlobal ? `Documento: ${documentoGlobal}` : ''}`, () => { deletaDadosDigitados(); window.location.href = `${BASE_URI}/importacao` });
    } catch (e) {
      console.log(e)
    } finally {
      $.LoadingOverlay('hide')
    }

  }

  function montaJsonItens() {
    const itensDataTable = $("#tabelaImportacao").DataTable().data().toArray();
    const itens = itensDataTable.map((itemDT) => {
      const item = {
        codigo: itemDT[0],
        descricao: itemDT[1],
        cor: itemDT[2],
        tam: itemDT[3],
        qtde: itemDT[4],
        barra: itemDT[5],
        barra28: itemDT[6],
        barracli: itemDT[7],
        ativo: itemDT[8],
        preco: itemDT[9],
        qtdeConf: itemDT[10],
        qualidade: itemDT[11],
        lote: itemDT[12]
      };
      return item;
    });
    return itens;
  }

  function montaJsonArquivo() {
    const importacao = {
      lancamento: $("#txtLancamento").val(),
      documento: $("#txtDocumento").val(),
      nota: $("#txtNota").val(),
      empresa: $("#txtEmpresa").val(),
      deposito: $("#txtDeposito").val(),
      depositoSaida: $("#txtDepositoSaida").val(),
      qualidade: $("#txtQualidade").val(),
      numerorfid: $('#txtNumLeitura').val(),
      rfid: bRFID,
      itens: montaJsonItens(),
      barrasbipadas: listaBarrasBipadas,
      tpMovimento: $("#txtTpMovimento").val()
    };
    return importacao;
  }

  async function carregaDadosDigitados() {
    const hostname = `JsonImportacao-${getCookie("idMaquina")}`;
    let response;
    let myHeaders = new Headers();
    myHeaders.append("pragma", "no-cache");
    myHeaders.append("cache-control", "no-cache");
    try {
      response = await fetch(`${hostname}.txt`, {
        headers: myHeaders,
        method: "GET",
        body: null,
      });
    } catch (error) {
      return;
    }
    return response;
  }

  async function salvaDadosDigitados() {
    try {
      const objeto = montaJsonArquivo();

      await salvaArquivo('JsonImportacao', objeto);

    } catch (error) {
      msgAlerta("Erro ao salvar dados digitados!");
    }
  }

  async function deletaDadosDigitados() {
    const hostname = `JsonImportacao-${getCookie("idMaquina")}`;
    try {
      const response = await fetch(
        `deletar_arquivo.php?nomedoarquivo=${hostname}.txt`,
        {
          method: "GET",
          body: null,
        }
      );
    } catch (error) { }
  }

  async function VerificaQuantidadeConferida() {
    const DataTable = $("#tabelaImportacao").DataTable().rows().data();
    let objetoConferido;
    let arrayObjetoConferido = [];
    DataTable.each((data) => {
      if (data[4] != data[10]) {
        objetoConferido = {
          CODIGO: data[0],
          QTDE: data[4],
          QTDECONFERIDA: data[10],
        };

        arrayObjetoConferido.push(objetoConferido);
      }
    });

    return arrayObjetoConferido.length > 0 ? arrayObjetoConferido : [];
  }

  async function ImprimirRelatorio() {
    $.LoadingOverlay('show');
    try {
      let dadosBackEnd = {};
      let arrayTransferencia = [];
      let tipoItem = '';
      if ($('#radioMaterial').prop('checked')) {
        tipoItem = 'M'
      } else {
        tipoItem = 'P'
      };
      const Dados = $("#tabelaImportacao").DataTable().rows().data();
      const { document } = await retornaDocumentoGravarMaterial()
      Dados.each((campo) => {
        dadosBackEnd = {
          CODIGO: campo[0],
          DESCRICAO: campo[1],
          COR: campo[2],
          TAMANHO: campo[3],
          QTDE: parseFloat(campo[4]),
          BARRA: campo[5],
          BARRA28: campo[6],
          BARRACLI: campo[7],
          ATIVO: campo[8],
          PRECO: parseFloat(campo[9]),
          QTDECONFERIDA: parseFloat(campo[10]),
          NUM_DOCTO: document,
          DEPOSITO_SAIDA: pegaChave('#txtDepositoSaida'),
          DEPOSITO: pegaChave('#txtDeposito'),
          QUALIDADE: campo[11],
          LOTE: $(campo[12]).find('span').text().trim() !== '' ? $(campo[12]).find('span').text().trim() : campo[12],
        };
        arrayTransferencia.push(dadosBackEnd);
      });
      const url = `/sisplan/impressao/v1/imprimitransferenciafilial?`;
      const params = `JSON=${JSON.stringify(arrayTransferencia)}&TIPO_ITEM=${tipoItem}`;
      const response = await requisicao("POST", url, "", params, null);
      const arquivo = await response.text();

      if (arquivo != undefined) {
        window.open(`${BASE_URI}/relatorios_api/pdf/${arquivo}`, "_blank");
        await limparRelatorios();
      }
    } finally {
      $.LoadingOverlay('hide');
    }
  };

  function zeraQtdeConf() {
    $("#tabelaImportacao").DataTable().rows().data().map((item, index) => {
      item[10] = 0;
      $("#tabelaImportacao").DataTable().row(index).data(item).draw(false);
    });
    barraNaoEncontrada = [];
    $("#btnRFID").removeClass("d-none");
  }

  async function buscaDadosRFID() {
    const url = `/sisplan/estoque/v1/buscadadosrfid?`;
    const params = `NUMERO=${$('#txtNumLeitura').val()}&DEPOSITO=${pegaChave('#txtDeposito')}&TIPO=E`;
    const response = await requisicao("GET", url, params, null, 300000);

    if (!response) {
      return "";
    }

    const jsonStr = await response.json();
    if (response.status != 200) {
      msgErro(jsonStr.mensagem);
      $.LoadingOverlay("hide");
      return;
    }

    $("#btnRFID").addClass("d-none");
    bRFID = true;
    bRFIDAbort = false;
    await Promise.all(jsonStr.map(async (item) => {
      if (bRFIDAbort) {
        return;
      }
      $("#txtConferencia").val(item.BARRA);
      await LocalizaBarraGrid();
    }));
  };

  async function filtroTipo(bProduto) {
    $('#txtDocumento').unbind('autocompleta');
    $('#btn-documento').unbind('pesquisa_serverside');
    const depositos = await buscaValor('EMPRESA', 'EMP_DEPOSITO', 'EMP_ID', getCookie('emp_id'))
    const tpMov = $("#radioNormal").prop("checked") ? ` AND TIP_BAI <> 'T' ` : '';

    if (depositos.EMP_DEPOSITO != '') {
      if (bProduto) {
        $("#txtDocumento").autocompleta(3, `JSON={ "tabela":"pa_mov", "camposSelect":["NUM_DOCTO CHAVE", "DT_MVTO DESCRICAO"], "where": ["DEPOSITO IN (${depositos.EMP_DEPOSITO}) ${tpMov}", "NOT EXISTS (SELECT NF_CONF_ENTRA.NUMERO FROM [NF_CONF_ENTRA] NF_CONF_ENTRA WHERE PA_MOV.NUM_DOCTO = NF_CONF_ENTRA.DOCTO_S)"]}`);
        $("#btn-documento").pesquisa_serverside(["#txtDocumento"], ["NUM_DOCTO"], ["DT_MVTO"], `{"tabela":"pa_mov", "camposSelect":[ "NUM_DOCTO", "DT_MVTO", "DEPOSITO" ], "orderBy": ["DT_MVTO DESC"], "groupBy": ["NUM_DOCTO", "DT_MVTO", "DEPOSITO"], "where": ["OPERACAO  = 'S' AND DEPOSITO IN (${depositos.EMP_DEPOSITO}) ${tpMov}", "NOT EXISTS (SELECT NF_CONF_ENTRA.NUMERO FROM [NF_CONF_ENTRA] NF_CONF_ENTRA WHERE PA_MOV.NUM_DOCTO = NF_CONF_ENTRA.DOCTO_S)"]}`, "Pesquisa Importação");
      } else {
        $("#txtDocumento").autocompleta(3, `JSON={ "tabela":"mat_mov", "camposSelect":["NUM_DOCTO CHAVE", "DT_MOVTO DESCRICAO"], "where": ["DEPOSITO IN (${depositos.EMP_DEPOSITO})", "NOT EXISTS (SELECT NF_CONF_ENTRA.NUMERO FROM [NF_CONF_ENTRA] NF_CONF_ENTRA WHERE MAT_MOV.NUM_DOCTO = NF_CONF_ENTRA.DOCTO_S)"]}`);
        $("#btn-documento").pesquisa_serverside(["#txtDocumento"], ["NUM_DOCTO"], ["DT_MOVTO"], `{"tabela":"mat_mov", "camposSelect":[ "NUM_DOCTO", "DT_MOVTO", "DEPOSITO" ], "orderBy": ["DT_MOVTO DESC"], "groupBy": ["NUM_DOCTO", "DT_MOVTO", "DEPOSITO"], "where": ["OPERACAO  = 'S' AND DEPOSITO IN (${depositos.EMP_DEPOSITO})", "NOT EXISTS (SELECT NF_CONF_ENTRA.NUMERO FROM [NF_CONF_ENTRA] NF_CONF_ENTRA WHERE MAT_MOV.NUM_DOCTO = NF_CONF_ENTRA.DOCTO_S)"]}`, "Pesquisa Importação");
      }
    } else {
      if (bProduto) {
        const tpMovAutoCompleta = tpMov != '' ? `["${tpMov.split('AND')[1]}", "NOT EXISTS (SELECT NF_CONF_ENTRA.NUMERO FROM [NF_CONF_ENTRA] NF_CONF_ENTRA WHERE PA_MOV.NUM_DOCTO = NF_CONF_ENTRA.DOCTO_S)"]` : `["NOT EXISTS (SELECT NF_CONF_ENTRA.NUMERO FROM [NF_CONF_ENTRA] NF_CONF_ENTRA WHERE PA_MOV.NUM_DOCTO = NF_CONF_ENTRA.DOCTO_S)"]`
        $("#txtDocumento").autocompleta(3, `JSON={ "tabela":"pa_mov", "camposSelect":["NUM_DOCTO CHAVE", "DT_MVTO DESCRICAO"], "where": ${tpMovAutoCompleta}}`);
        $("#btn-documento").pesquisa_serverside(["#txtDocumento"], ["NUM_DOCTO"], ["DT_MVTO"], `{"tabela":"pa_mov", "camposSelect":[ "NUM_DOCTO", "DT_MVTO", "DEPOSITO" ], "orderBy": ["DT_MVTO DESC"], "groupBy": ["NUM_DOCTO", "DT_MVTO", "DEPOSITO"], "where": ["OPERACAO  = 'S' ${tpMov}", "NOT EXISTS (SELECT NF_CONF_ENTRA.NUMERO FROM [NF_CONF_ENTRA] NF_CONF_ENTRA WHERE PA_MOV.NUM_DOCTO = NF_CONF_ENTRA.DOCTO_S)"]}`, "Pesquisa Importação");
      } else {
        $("#txtDocumento").autocompleta(3, `JSON={ "tabela":"mat_mov", "camposSelect":["NUM_DOCTO CHAVE", "DT_MOVTO DESCRICAO"], "where": ["NOT EXISTS (SELECT NF_CONF_ENTRA.NUMERO FROM [NF_CONF_ENTRA] NF_CONF_ENTRA WHERE MAT_MOV.NUM_DOCTO = NF_CONF_ENTRA.DOCTO_S)"]}`);
        $("#btn-documento").pesquisa_serverside(["#txtDocumento"], ["NUM_DOCTO"], ["DT_MOVTO"], `{"tabela":"mat_mov", "camposSelect":[ "NUM_DOCTO", "DT_MOVTO", "DEPOSITO" ], "orderBy": ["DT_MOVTO DESC"], "groupBy": ["NUM_DOCTO", "DT_MOVTO", "DEPOSITO"], "where": ["OPERACAO  = 'S'", "NOT EXISTS (SELECT NF_CONF_ENTRA.NUMERO FROM [NF_CONF_ENTRA] NF_CONF_ENTRA WHERE MAT_MOV.NUM_DOCTO = NF_CONF_ENTRA.DOCTO_S)"]}`, "Pesquisa Importação");
      }
    }
  }
});
