$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false,
            animate: true
        });

        driver.defineSteps([{
            element: '#campostour',
            popover: {
                title: 'Dados Gerais',
                description: 'Aqui estão os campos disponíveis para o cadastro, os campos obrigatórios terão o * ao lado do nome.',
                position: 'top'
            }
        },
        {
            element: "#btnVoltar",
            popover: {
                title: "Botão Voltar",
                description:
                    "Ao clicar nesse botão você retorna para a tela de consulta.",
                position: "left",
            },
        },
        {
            element: '#gravar',
            popover: {
                title: 'Botão Gravar',
                description: 'Clique aqui para gravar a máquina de cartão.',
                position: 'left'
            }
        }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {


    $('#btnVoltar').on('click', async function () {
        window.location.href = `${BASE_URI}/maquinacartao`;
    });

    $(document).ready(function () {

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtNrserie: {
                    required: true,
                },
                txtIdentificador: {
                    required: true,
                },
                txtDescricao: {
                    required: true,
                }
            },
            messages: {
                txtNrserie: {
                    required: "Informe um número de série válido."
                },
                txtIdentificador: {
                    required: "Informe um identificador válido."
                },
                txtDescricao: {
                    required: "Informe uma descrição válida."
                }
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        $('.radio-group .radio').click(function () {
            $(this).parent().find('.radio').removeClass('selected');
            $(this).addClass('selected');
        });

        $(".submit").click(function () {
            return false;
        });
    });

    $('#txtNrserie').on('change', async function () {
        if ($('#txtNrserie').val() != '') {
            try {
                $.LoadingOverlay('show');

                let nrserie = $('#txtNrserie').val();

                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                        `JSON={ "tabela":"maquina_cartao", 
                "camposSelect":["nrserie"], 
                "where": ["nrserie = '${nrserie}'"]}`, null);

                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (jsonStr.RESULT[0].length > 0) {
                        msgAlerta('Máquina de cartão já cadastrada.');
                        $('#txtNrserie').val('');
                    }
                } catch (error) {
                    console.error(error);
                }
            } finally {
                $.LoadingOverlay('hide');
            }
        }
    });

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let maquina = parametros[parametros.length - 1];

    if (maquina != '' && maquina != 'create') {

        $('#txtNrserie').attr('disabled', 'disabled');
        $('#txtNrserie').prop('readonly', true);

        try {
            $.LoadingOverlay("show");
            try {
                let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?',
                    `JSON={ "tabela":"maquina_cartao", 
                    "camposSelect":["nrserie", "identificador", "descricao"], 
                    "where": ["nrserie = '${maquina}'"]}`, null);

                if (!response) {
                    return;
                }
                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }

                $('#txtNrserie').val(jsonStr.RESULT[0][0].NRSERIE);
                $('#txtIdentificador').val(jsonStr.RESULT[0][0].IDENTIFICADOR);
                $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);

            } catch (error) {
                console.error(error);
                msgErro(`Não foi possível buscar os dados da máquina: ${error}`);
            }
        } finally {
            $.LoadingOverlay('hide');
        }
    };

    $("#gravar").click(

        async function () {

            let validator = $("#msform").validate();
            validator.form();
            let erros = 0;
            erros = validator.numberOfInvalids();

            if (erros == 0) {
                try {
                    $.LoadingOverlay("show");

                    maquina = {};

                    maquina.NRSERIE = $('#txtNrserie').val();
                    maquina.IDENTIFICADOR = $('#txtIdentificador').val().toUpperCase();
                    maquina.DESCRICAO = $('#txtDescricao').val().toUpperCase();

                    let response = await requisicao('POST', '/Sisplan/Cadastros/v1/maquinacartao?', `JSON=${encodeURIComponent(JSON.stringify(maquina))}`, null);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        `Cadastro da máquina: ${maquina.DESCRICAO} efetuado com sucesso!`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/maquinacartao`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });

                } catch (error) {
                    console.error(error);
                    $.LoadingOverlay("hide");
                    msgErro(`Não foi possível gravar os dados do tamanho: ${error}`);
                }
            }
        });
});