$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#btnFiltros',
                popover: {
                    title: 'Botão Filtros',
                    description: 'Clique aqui para filtrar a consulta.',
                    position: 'right'
                }
            },
            {
                element: '#btnNovoPreco',
                popover: {
                    title: 'Botão Incluir',
                    description: 'Clique aqui para iniciar o cadastro de preço por cor e tamanho.',
                    position: 'right'
                }
            },
            {
                element: '#tabelaPreco',
                popover: {
                    title: 'Tabela Preços',
                    description: 'Aqui estarão os preços cadastrados de acordo com o seu filtro.',
                    position: 'top'
                }
            }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    const permissaoUsuarioLogado = await permissaoAcessos("PRECOCORTAM");

    $('#txtTabPreco').autocompleta(1, `JSON={ "tabela":"REGIAO", "camposSelect":[ "REGIAO chave", "descricao descricao"], "where": null}`);
    $('#txtProduto').autocompleta(3, `JSON={ "tabela":"produto", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);
    $('#txtMaterial').autocompleta(3, `JSON={ "tabela":"material", "camposSelect":[ "codigo chave", "descricao descricao"], "where": null}`);

    $('#btnTabPreco').pesquisa('#txtTabPreco', 'REGIAO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"REGIAO", "camposSelect":[ "REGIAO", "DESCRICAO"]}`, 'Pesquisa Tabela de Preço', 'regiao');
    $('#btnProduto').pesquisa('#txtProduto', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"produto", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Produto', 'produto');
    $('#btnMaterial').pesquisa('#txtMaterial', 'CODIGO', 'DESCRICAO', `/sisplan/funcoes/v1/pesquisa?JSON={"tabela":"material", "camposSelect":[ "CODIGO", "DESCRICAO"]}`, 'Pesquisa Material', 'material');

    $('#btnExcluiTabPreco').on('click', function () {
        $('#txtTabPreco').val('');
    });
    $('#btnExcluiProduto').on('click', function () {
        $('#txtProduto').val('');
    });
    $('#btnExcluiMaterial').on('click', function () {
        $('#txtMaterial').val('');
    });

    $('#btnFiltros').on('click', function () {
        $('#modal-filtros').modal('show');
    });

    function retornaBotaoOpcoes(data) {
        var retorno = '<div style="text-align:start;"> ' +
            '    <button class="btn btn-info btn-sm dropdown-toggle btnVerificaOpcoes" type="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"> ' +
            '      ' + data + ' ' +
            '    </button> ' +
            '    <div class="dropdown-menu"> ' +
            '    <button class="dropdown-item" type="button" title="Editar" id="btn-editar">Editar</button>     ' +
            '    <button class="dropdown-item" type="button" title="Excluir" id="btn-excluir">Excluir</button>  ' +
            '</div>';
        return retorno;
    };

    $('#btnConsultar').on('click', async function () {
        $('#modal-filtros').modal('hide');
        await consultaPreco(true);
    });

    $('#btnLimparFiltros').on('click', async function () {
        $('#txtTabPreco').val('');
        $('#txtProduto').val('');
        $('#txtMaterial').val('');
        $("#txtTipo").val("");
    });



    async function consultaPreco() {
        try {
            $.LoadingOverlay("show");
            let tipo = $("#txtTipo").val() != '' ? `AND PRECO_COR_TAM.TIPO = '${$('#txtTipo').val()}'` : '';
            let codigoProduto = pegaChave('#txtProduto') != '' ? `AND PRECO_COR_TAM.CODIGO = '${pegaChave('#txtProduto')}'` : '';
            let codigoMaterial = pegaChave('#txtMaterial') != '' ? `AND PRECO_COR_TAM.CODIGO = '${pegaChave('#txtMaterial')}'` : '';
            let tabelapreco = pegaChave('#txtTabPreco') != '' ? `AND PRECO_COR_TAM.REGIAO = '${pegaChave('#txtTabPreco')}'` : '';
            const response = await requisicao('GET', '/Sisplan/Funcoes/V1/pesquisa?', `JSON={ "tabela":"PRECO_COR_TAM", "camposSelect":[ "PRECO_COR_TAM.CODIGO", "PRECO_COR_TAM.TIPO", "CASE WHEN PRECO_COR_TAM.TIPO = 'P' THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END DESCRICAO", "PRECO_COR_TAM.REGIAO", "REGIAO.DESCRICAO DESC_REGIAO"], 
                "leftjoin": [{"tabela" : "PRODUTO", "condicao" : "PRODUTO.CODIGO = PRECO_COR_TAM.CODIGO AND PRECO_COR_TAM.TIPO = 'P'"}, {"tabela" : "MATERIAL", "condicao" : "MATERIAL.CODIGO = PRECO_COR_TAM.CODIGO AND PRECO_COR_TAM.TIPO = 'M'"}, {"tabela" : "REGIAO", "condicao" : "REGIAO.REGIAO = PRECO_COR_TAM.REGIAO"}],
                "groupby": ["PRECO_COR_TAM.CODIGO", "PRECO_COR_TAM.REGIAO", "CASE WHEN PRECO_COR_TAM.TIPO = 'P' THEN PRODUTO.DESCRICAO ELSE MATERIAL.DESCRICAO END", "REGIAO.DESCRICAO", "PRECO_COR_TAM.TIPO"],
                "where": ["1=1 ${codigoProduto} ${codigoMaterial} ${tabelapreco} ${tipo}"]}`, null);

            if (!response) {
                $.LoadingOverlay("hide");
                return;
            }

            let jsonStr = await response.json();
            if (response.status != 200) {
                $.LoadingOverlay("hide");
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }

            let colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
            if (colunasInvisiveis == null || colunasInvisiveis.acessoCadPrecoCorTam == undefined) {
                localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadPrecoCorTam: ['EMPRESA'] }));
                colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'));
            }

            $('#tabelaPreco').DataTable({
                destroy: true,
                lengthChange: true,
                paging: true,
                searching: true,
                scrollX: true,
                scrollY: '350px',
                "autoWidth": true,
                "data": jsonStr.RESULT[0],
                "columns": [{
                    data: "CODIGO",
                    title: "Código"
                },
                {
                    data: "DESCRICAO",
                    title: "Descrição"
                },
                {
                    data: "REGIAO",
                    title: "Região"
                },
                {
                    data: "DESC_REGIAO",
                    title: "Desc. Região"
                },
                {
                    data: "TIPO",
                    title: "Tipo"
                },
                ],
                "columnDefs": [{
                    targets: [0], render: function (data, type, row) {
                        return retornaBotaoOpcoes(data);
                    }
                }]
            });

            $('#tabelaPreco_length').prepend('<button class="buttonColVis" id="buttonColVis"><i class="fas fa-cogs"></i></button>');
            $('#tabelaPreco_length').prepend('<button class="buttonExcel" id="buttonExcel"><i class="fas fa-file-excel"></i></button>');

            $('#buttonColVis').prop('title', 'Configurar colunas visíveis')
            $('#buttonExcel').prop('title', 'Exportar')

            $('#buttonColVis').on('click', async function () {
                $.LoadingOverlay('show');
                $('#modal-ColunasVisiveis').modal('show');
                $.LoadingOverlay('hide');
            });

            $('#buttonExcel').on('click', async function () {
                const dados = $("#tabelaPreco").DataTable().data().toArray();
                await exportaCSV("", "", undefined, null, 'Relatório da aba de acesso cadastro de Preço por Cor e Tamanho', '', '', 999, false, false, dados);
            });

            $('#tabelaPreco').DataTable().columns().every(function () {
                if ((colunasInvisiveis.acessoCadPrecoCorTam).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            });

            $.LoadingOverlay("hide");
        } catch (error) {
            console.error(error);
            $.LoadingOverlay("hide");
        }
    }

    $('#modal-ColunasVisiveis').on('show.bs.modal', function () {
        const cols = [];
        colunasInvisiveis = JSON.parse(localStorage.getItem('colunasInvisiveisRelatorios'))

        $('#tabelaPreco').DataTable().columns().every(function () {
            cols.push({
                'title': $(this.header()).text(),
                'data': this.dataSrc()
            });
        });

        adicionaColunas(cols, colunasInvisiveis.acessoCadPrecoCorTam ?? ['EMPRESA']);
    });

    $('#btnConfirmarColunas').on('click', async function () {
        try {
            $.LoadingOverlay('show');

            const novasColunas = retornaNovasColunasInvisiveis();
            removeColunasFixas(novasColunas, ["CODIGO"]);
            localStorage.setItem('colunasInvisiveisRelatorios', JSON.stringify({ ...colunasInvisiveis, acessoCadPrecoCorTam: novasColunas }));

            $('#tabelaPreco').DataTable().columns().visible(true);

            $('#tabelaPreco').DataTable().columns().every(function () {
                if ((novasColunas).indexOf(this.dataSrc()) != -1) {
                    this.visible(false);
                }
            });

        } finally {
            $.LoadingOverlay('hide');
            $('#modal-ColunasVisiveis').modal('hide');
        }
    });

    $('#tabelaPreco').on('click', '#btn-editar', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaPreco').DataTable().row($(this).parents('tr')).data();
            let registroLiberado = await verificarRegistro('PRECOCORTAM', String(data.REGIAO) + String(data.CODIGO + String(data.TIPO)));
            if (registroLiberado) {
                window.location.href = `precocortam/${btoa(`${data.REGIAO}/${data.CODIGO}/${data.TIPO}`)}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaPreco').on('dblclick', 'tr', async function () {
        if (permissaoUsuarioLogado.ALTERA == 'S') {
            let data = $('#tabelaPreco').DataTable().row($(this)).data();
            let registroLiberado = await verificarRegistro('PRECOCORTAM', String(data.REGIAO) + String(data.CODIGO) + String(data.TIPO));
            if (registroLiberado) {
                window.location.href = `precocortam/${btoa(`${data.REGIAO}/${data.CODIGO}/${data.TIPO}`)}`;
            }
        } else {
            msgAlertaSemConfirmacao("Sem permissão para alterar!");
        }
    });

    $('#tabelaPreco').on('click', '#btn-excluir', async function () {
        if (permissaoUsuarioLogado.EXCLUI == 'S') {
            msgAlerta('Você realmente deseja excluir esse registro?', async () => {
                const data = $("#tabelaPreco").DataTable().row($(this).parents("tr"));
                await excluiRegistro(data);
            });
        } else {
            msgAlertaSemConfirmacao("Sem permissão para excluir!");
        }
    });

    $("#btnNovoPreco").on("click", function () {
        if (permissaoUsuarioLogado.INCLUI == 'S') {
            window.location.href = "precocortam/create";
        } else {
            msgAlertaSemConfirmacao("Sem permissão para incluir!");
        }
    });

    async function excluiRegistro(data) {
        try {
            $.LoadingOverlay("show");
            try {
                let valorLinha = data.data();
                let response = await requisicao("DELETE", "/Sisplan/cadastros/v1/precocortam?", `CODIGO=${(valorLinha.CODIGO)}&REGIAO=${(valorLinha.REGIAO)}`, null);
                if (!response) {
                    return;
                }
                if (response.status != 200) {
                    let jsonStr = await response.json();
                    msgErro(jsonStr.mensagem);
                    return;
                }

                toastr.success("Exclusão efetuada com sucesso!", "Confirmação", {
                    toastClass: "success",
                    iconClasses: {
                        error: "alert-error",
                        info: "alert-info",
                        success: "alert-success",
                        warning: "alert-warning",
                    },
                    positionClass: "toast-top-center",
                    progressBar: true,
                    timeOut: 3000,
                    fadeOut: 1000,
                    onHidden() {
                        data.remove().draw(false);
                    },
                }).css({
                    "margin-top": "20%",
                    width: "500px",
                    "max-width": "500px",
                });

            } catch (error) {
                console.error(error);
            }
        } finally {
            $.LoadingOverlay("hide");
        }
    }

    $('#btnConsultar').trigger('click');
});