$('#tutorial').on('click', function () {
    $(document).ready(async function () {
        const driver = new Driver({
            doneBtnText: 'Sair',
            closeBtnText: 'Fechar',
            nextBtnText: 'Próximo',
            prevBtnText: 'Anterior',
            allowClose: false
        });
        driver.defineSteps([

            {
                element: '#campostour',
                popover: {
                    title: 'Dados Gerais',
                    description: 'Aqui estão os campos disponíveis para o cadastro. Campos obrigatórios terão um * ao lado do nome.',
                    position: 'top'
                }
            },
            {
                element: '#tutorialAtivo',
                popover: {
                    title: 'Ativo',
                    description: 'Aqui marcamos se esse cadastro estará ativo.',
                    position: 'top'
                }
            },
            {
                element: '#tutorialPadrao',
                popover: {
                    title: 'Padrão',
                    description: 'Aqui selecionamos se será a situação de duplicata padrão, pode ser selecionada apenas um dos registros.',
                    position: 'top'
                }
            },
            {
                element: '#txtCodigo',
                popover: {
                    title: 'Padrão',
                    description: 'Este campo é preenchido automaticamente.',
                    position: 'top'
                }
            },
            {
                element: '#txtDescricao',
                popover: {
                    title: 'Descrição',
                    description: 'Este campo adicionamos uma descrição da duplicata.',
                    position: 'top'
                }
            },
            {
                element: '#btnVoltar',
                popover: {
                    title: 'Botão Voltar',
                    description: 'Clique aqui para voltar para a tela de consulta.',
                    position: 'left'
                }
            },
            {
                element: '#btnGravar',
                popover: {
                    title: 'Botão Gravar',
                    description: 'Clique aqui para gravar a situação.',
                    position: 'left'
                }
            }
        ]);
        driver.start();
    });
});

$(document).ready(async function () {

    $('#txtCodigo').prop('disabled', false);
    $("#checkAtivo").attr("checked", true);

    let queryString = window.location.href;
    let parametros = queryString.split('/');
    let situacao = parametros[parametros.length - 1];

    $('#btnVoltar').on('click', async function () {
        await deletaRegistro('SITUACAODUPLICATA', getCookie('usuario'), String(situacao));
        window.location.href = `${BASE_URI}/situacaoduplicata`;
    });

    $(document).ready(async function () {

        $('#msform').validate({
            debug: false,
            ignore: "",
            rules: {
                txtDescricao: {
                    required: true,
                }
            },
            messages: {
                txtDescricao: {
                    required: "Informe uma descrição válida."
                }
            },
            errorElement: 'span',
            errorPlacement(error, element) {
                error.addClass('invalid-feedback');
                element.closest('.form-group').append(error);
            },
            highlight(element) {
                $(element).addClass('is-invalid');
            },
            unhighlight(element) {
                $(element).removeClass('is-invalid');
            }
        });

        if (situacao != '' && situacao != 'create') {
            if (await liberarRegistro('SITUACAODUPLICATA', situacao) == false) {
                window.location.href = '../situacaoduplicata';
            } else {
                carregaDados(situacao);
            }
        }

        async function carregaDados(situacaoUrl) {
            try {
                $.LoadingOverlay("show");
                try {
                    let response = await requisicao('GET', '/Sisplan/Funcoes/v1/pesquisa?', `JSON={ 
                            "tabela":"TABSIT", 
                            "camposSelect":["CODIGO", "ABREVI", "DESCRICAO", "ATIVO", "PADRAO", "GERA_BOLETO"], 
                            "where": ["CODIGO = '${situacaoUrl}'"]}`, null);
                    if (!response) {
                        return;
                    }
                    let jsonStr = await response.json();
                    if (response.status != 200) {
                        msgErro(jsonStr.RESULT[0].mensagem);
                        return;
                    };

                    $('#txtCodigo').val(jsonStr.RESULT[0][0].CODIGO);
                    $('#txtDescricao').val(jsonStr.RESULT[0][0].DESCRICAO);
                    $('#txtAbrev').val(jsonStr.RESULT[0][0].ABREVI);

                    if (jsonStr.RESULT[0][0].ATIVO == 'S') {
                        $('#checkAtivo').prop('checked', true);
                    };
                    if (jsonStr.RESULT[0][0].PADRAO == 'S') {
                        $('#checkPadrao').prop('checked', true);
                    };
                    if (jsonStr.RESULT[0][0].GERA_BOLETO == 'S') {
                        $('#checkBoleto').prop('checked', true);
                    };

                } catch (error) {
                    console.error(error);
                    msgErro(`Não foi possível buscar os dados da situação.`);
                };
            } finally {
                $.LoadingOverlay('hide');
            }
        };

        $(".submit").click(function () {
            return false;
        });
    });

    $("#checkPadrao").on("click", async function () {
        if ($("#checkPadrao").prop("checked")) {
            try {
                let response = await requisicao(
                    "GET",
                    "/Sisplan/Funcoes/v1/pesquisa?",
                    `JSON={ "tabela":"TABSIT", "camposSelect":["CODIGO,PADRAO"], "where":[" PADRAO = 'S' "]}`,
                    null
                );

                if (!response) {
                    return;
                }
                let jsonStr = await response.json();
                if (response.status != 200) {
                    msgErro(jsonStr.RESULT[0].mensagem);
                    return;
                }
                if (jsonStr.RESULT[0].length != 0) {
                    $("#checkPadrao").trigger("click");
                    $("#checkPadrao").attr("checked", false);
                    msgAlerta(`A situação ${jsonStr.RESULT[0][0].CODIGO} já está como padrão`);
                }
            } catch (error) {
                console.error(error);
            }
        }
    });

    async function consultaDescricaoIgual() {
        if (situacao === 'create') {
            const descricao = $('#txtDescricao').val();
            let response = await requisicao(
                "GET",
                "/Sisplan/Funcoes/v1/pesquisa?",
                `JSON={ "tabela":"TABSIT", "camposSelect":["CODIGO,DESCRICAO"], "where":[" DESCRICAO = '${descricao}' "]}`,
                null
            );

            if (!response) {
                return;
            }
            let jsonStr = await response.json();
            if (response.status != 200) {
                msgErro(jsonStr.RESULT[0].mensagem);
                return;
            }
            if (jsonStr.RESULT[0].length != 0) {
                return true;
            }
            return false;
        }
    };

    $("#btnGravar").click(
        async function () {
            try {
                let validator = $("#msform").validate();
                validator.form();
                let erros = 0;
                erros = validator.numberOfInvalids();

                if (erros == 0) {
                    $.LoadingOverlay("show");

                    if ($('#txtDescricao').val() === '') {
                        msgAlerta(`Necessário informar uma descrição.`);
                    }

                    descricaoIgual = await consultaDescricaoIgual();

                    if (descricaoIgual) {
                        msgAlerta(`Já existe uma situação com esta descrição.`);
                        $.LoadingOverlay("hide");
                        return;
                    }

                    situacao = {};

                    situacao.CODIGO = $('#txtCodigo').val() == '' ? await RetornaProximo('TABSIT', 'TABSIT', 'CODIGO', 5) : $('#txtCodigo').val();
                    situacao.DESCRICAO = $('#txtDescricao').val().toUpperCase();;
                    situacao.ABREVI = $('#txtAbrev').val().toUpperCase();;

                    if ($('#checkAtivo').prop('checked')) {
                        situacao.ATIVO = 'S';
                    } else {
                        situacao.ATIVO = 'N';
                    }

                    if ($('#checkPadrao').prop('checked')) {
                        situacao.PADRAO = 'S';
                    } else {
                        situacao.PADRAO = 'N';
                    }

                    if ($('#checkBoleto').prop('checked')) {
                        situacao.GERA_BOLETO = 'S';
                    } else {
                        situacao.GERA_BOLETO = 'N';
                    }

                    let response = await requisicao('POST', '/sisplan/cadastros/v1/situacaoduplicata?', '', JSON.stringify(situacao), 15000);

                    if (!response) {
                        $.LoadingOverlay("hide");
                        return;
                    };

                    if (response.status != 200) {
                        let jsonStr = await response.json();
                        $.LoadingOverlay("hide");
                        msgErro(jsonStr.mensagem);
                        return;
                    }
                    $.LoadingOverlay("hide");
                    toastr.success(
                        `Cadastro efetuado com sucesso!
                        Situação: ${situacao.CODIGO}`,
                        'Confirmação', {
                        toastClass: 'alert',
                        iconClasses: {
                            error: 'alert-error',
                            info: 'alert-info',
                            success: 'alert-success',
                            warning: 'alert-warning'
                        },
                        positionClass: "toast-top-center",
                        progressBar: true,
                        timeOut: 3000,
                        fadeOut: 1000,
                        onHidden() {
                            window.location.href = `${BASE_URI}/situacaoduplicata`;
                        }
                    }
                    ).css({
                        "margin-top": "20%",
                        "width": "500px",
                        "max-width": "500px"
                    });
                };

            } catch (error) {
                console.error(error);
                $.LoadingOverlay("hide");
                msgErro(`Não foi possível gravar os dados da situação`);
            }

        });
});